<?php

namespace Modules\Flights\Http\Controllers;

use App\Models\FlightsBookingList;
use DateTime;
use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Flights\Http\Controllers\Sdk\Pkfare\PkfaresdkController;
use Modules\StaticData\Entities\Airport;

class PkfareController extends Controller
{
    public $partnerId;
    public $partnerKey;
    public $sign;
    public $PkFare_sdk;
    public $headers;
    public $lang;
    public $currency;
    public $country;

    public function __construct()
    {
        $headers = request()->header();
        $this->PkFare_sdk = new PkfaresdkController;
        $this->lang = $headers['x-language-code'][0];
        $this->country = $headers['x-country-code'][0];
        $this->currency = $headers['x-currency-code'][0];
        //Supplier Credentials
        //test
        $this->partnerId = 'cfNAFOC65OLIFAWWdo4OiEDreZY=';
        $this->partnerKey = 'Y2YxN2E2Yzk1MGZhNDg5NTY2ZTU1ZGY2ZGRjNDU0MGI=';
        //prod
        // $this->partnerId = "AfB7KsSjRpBJ8P2U++FuctSrAiU=";
        // $this->partnerKey = "MWExZjFmZDBiMjVhYTNjN2NkY2ViZTIxMWNmZDJiODI=";
        $this->sign = md5($this->partnerId . $this->partnerKey);
    }

    //================================================== Search Fucntion =============================================
    public function search($input)
    {
        $flights = [];
        $airline_list = [];
        $airport_list = [];
        $craft_list = [];

        if ($this->sign) {
            $input['Type'] = strtoupper($input['Type']);

            switch ($input['Type']) {
                case "ONEWAY":
                    $type = 1;
                    break;
                case "ROUND":
                    $type = 2;
                    break;
                case "MULTIPLE":
                    $type = 3;
                    break;
            }

            $cabin = $input['Cabin'];
            $segments = [];
            $legs = $input['Legs'];

            for ($i = 0; $i < count($legs); $i++) {
                switch ($i) {
                    case 0:
                        $type = 1;
                        break;
                    case 1:
                        $type = 2;
                        break;
                    case 2:
                        $type = 3;
                        break;
                    case 3:
                        $type = 3;
                        break;
                    case 4:
                        $type = 3;
                        break;
                    case 5:
                        $type = 3;
                        break;
                }
                $segments[] =
                    [
                        'Origin' => $legs[$i]['departureCode'],
                        'Destination' => $legs[$i]['arrivalCode'],
                        'PreferredDepartureTime' => $legs[$i]['outboundDate'] . 'T00:00:00',
                        'PreferredArrivalTime' => $legs[$i]['outboundDate'] . 'T00:00:00',
                    ];
            }

            $searchAirLegs = [];
            foreach ($input['Legs'] as $leg) {
                $searchLeg = [
                    'cabinClass' => ucfirst(strtolower($cabin)),
                    'departureDate' => $leg['outboundDate'],
                    'origin' => $leg['departureCode'],
                    'destination' => $leg['arrivalCode'],
                ];
                array_push($searchAirLegs, $searchLeg);
            }
            $post_data = array(
                'authentication' => array(
                    'partnerId' => $this->partnerId,
                    'sign' => $this->sign,
                ),

                'search' => array(
                    'adults' => (int) $input['AdultCount'],
                    // 'airline' => $input['Airline'],
                    'children' => (int) $input['ChildCount'],
                    'nonstop' => 0,
                    'searchAirLegs' => $searchAirLegs,
                ),
                'solutions' => 0,
            );
            //save request
            $file_name = 'flights_search_request.json';
            save_to_file($file_name, 'flights', 'pkfare', $post_data);
            //run request
            $url_part = 'shoppingV2';
            $request_name = 'search';
            $request_method = 'GET';
            $search_response = $this->PkFare_sdk->request($url_part, $post_data, $request_name, $request_method);
            $response = json_decode(gzdecode($search_response));
            $file_name = 'flights_search_response.json';
            save_to_file($file_name, 'flights', 'pkfare', $response);
            $session_key = generate_session_key();
            $mapped_flights = [];
            if ($response->errorCode == '0' && $response->errorMsg == 'ok' && $response->data != null && $response->data->solutions != null) {
                $search_results = $this->prepare_search_results($response);
                foreach ($search_results as $flight) {
                    $mapped_flights[$flight->solutionId] = $flight;
                    $is_lcc = '';
                    $legs = [];
                    foreach ($flight->journeys as $journey) {
                        $segments = [];
                        foreach ($journey->segments as $segment) {
                            $origin_data = $this->get_airport($segment->departure);
                            $destination_data = $this->get_airport($segment->arrival);
                            $stops_number = count($journey->segments) - 1;
                            $segments[] = [
                                'Origin' => [
                                    'AirportCode' => $segment->departure,
                                    'AirportName' => $origin_data ? $origin_data->name : $segment->departure,
                                    // 'CityCode' => '',
                                    'CityName' => $origin_data ? $origin_data->city->name : $segment->departure,
                                    'CountryCode' => $origin_data ? $origin_data->city->country->code : $segment->departure,
                                    'CountryName' => $origin_data ? $origin_data->city->country->name : $segment->departure,
                                    'Terminal' => $segment->departureTerminal,
                                ],
                                'Destination' => [
                                    'AirportCode' => $segment->arrival,
                                    'AirportName' => $destination_data ? $destination_data->name : $segment->arrival,
                                    // 'CityCode' => '',
                                    'CityName' => $destination_data ? $destination_data->city->name : $segment->arrival,
                                    'CountryCode' => $destination_data ? $destination_data->city->country->code : $segment->arrival,
                                    'CountryName' => $destination_data ? $destination_data->city->country->name : $segment->arrival,
                                    'Terminal' => $segment->arrivalTerminal,
                                ],
                                "AirlineDetails" => [
                                    "AirlineCode" => $segment->airline,
                                    "FlightNumber" => $segment->flightNum,
                                    "Craft" => $segment->equipment,
                                    "AirlineName" => $segment->airline,
                                    "OperatingCarrier" => $segment->opFltAirline,
                                ],
                                'Duration' => $this->flight_segment_duration($segment),
                                'TransitTime' => $segment->stayTime,
                                'DepartureTime' => date('Y-m-d H:i:s', $segment->departureDate / 1000),
                                'ArrivalTime' => date('Y-m-d H:i:s', $segment->arrivalDate / 1000),
                                'nextDay' => date('d', $segment->departureDate / 1000) != date('d', $segment->arrivalDate / 1000) ? date('d', $segment->arrivalDate / 1000) - date('d', $segment->departureDate / 1000)  : false
                            ];
                        }

                        $airline_list[] = $journey->segments[0]->airline;
                        $airport_list[] = $journey->segments[0]->departure;
                        $airport_list[] =  $journey->segments[$stops_number]->arrival;
                        $craft_list[] =  $journey->segments[0]->equipment;

                        $legs[] = [
                            'Origin' => [
                                'AirportCode' => $journey->segments[0]->departure,
                            ],
                            'Destination' => [
                                'AirportCode' => $journey->segments[$stops_number]->arrival,
                            ],
                            'AirlineDetails' => [
                                "AirlineCode" => $journey->segments[0]->airline,
                                "FlightNumber" => $journey->segments[0]->flightNum,
                                "Craft" => $journey->segments[0]->equipment,
                                "AirlineName" => $journey->segments[0]->airline,
                                "OperatingCarrier" => $journey->segments[0]->opFltAirline,
                            ],
                            'NoOfSeatAvailable' => $journey->segments[0]->availabilityCount,
                            'DepartureTime' => date('Y-m-d H:i:s', $journey->segments[0]->departureDate / 1000),
                            'ArrivalTime' => date('Y-m-d H:i:s', $journey->segments[$stops_number]->arrivalDate / 1000),
                            'Duration' => $this->flight_duration($journey, $stops_number),
                            'nextDay' => date('d', $journey->segments[0]->departureDate / 1000) != date('d', $journey->segments[0]->arrivalDate / 1000) ? date('d', $journey->segments[0]->arrivalDate / 1000) - date('d', $journey->segments[0]->departureDate / 1000)  : false,
                            'Segments' => $segments,
                            'Bags' => $flight->baggageMap->ADT ? $this->prepare_bags($flight->baggageMap) : null,
                            'CabinClass' => $journey->segments[0]->cabinClass,
                        ];
                    }
                    // $currency = $flight->currency;
                    // $amount = payment_currency(
                    //     ($flight->adtFare ?? 0) + ($flight->adtTax ?? 0) + ($flight->chdFare ?? 0) + ($flight->chdTax ?? 0) + ($flight->chnFare ?? 0) + ($flight->chnTax ?? 0) + ($flight->infFare ?? 0) + ($flight->infTax ?? 0),
                    //     $currency,
                    //     'SAR'
                    // );
                    $currency = 'USD';
                    $amount = ($flight->adtFare ?? 0) + ($flight->adtTax ?? 0) + ($flight->chdFare ?? 0) + ($flight->chdTax ?? 0) + ($flight->chnFare ?? 0) + ($flight->chnTax ?? 0) + ($flight->infFare ?? 0) + ($flight->infTax ?? 0);
                    $flights[] = [
                        'Session' => [
                            'Supplier' => 'pkfare',
                            'SupplierId' => get_supplier_id('pkfare'),
                            'ResultId' => $flight->solutionId,
                            'IsLcc' => $is_lcc,
                            'WowSessionKey' => $session_key,
                            'SupplierSessionKey' => $response->data->shoppingKey,
                        ],
                        'ResponseAmount' => $flight->adtFare + $flight->adtTax + $flight->chdFare + $flight->chdTax + $flight->chnFare + $flight->chnTax + $flight->infFare + $flight->infTax,
                        'ResponseCurrency' => $flight->currency,
                        'Amount' => $amount,
                        // 'Currency' => 'SAR',
                        'Currency' => $currency,
                        'Options' => [
                            [
                                'BookingInfo' => [
                                    'Amount' => $amount,
                                    // 'CurrencyCode' => 'SAR',
                                    'CurrencyCode' => $currency,
                                    'ResultId' => $flight->solutionId,
                                    'SupplierKey' => $input['SupplierKey'],
                                    'TrackingId' => $response->data->shoppingKey,
                                ],
                                'Legs' => $legs,
                            ],
                        ],
                    ];
                }
                $flights = $this->array_group_by($flights, 'Amount');

                //set session data
                $session_data = [
                    'TokenId' => $response->data->shoppingKey,
                    'TrackingId' => $response->data->shoppingKey,
                    'SearchRequest' => $input,
                    'SearchResponse' => $response,
                    'Flights' => $flights,
                    'MappedFlights' => $mapped_flights,
                ];
                set_session('flights', 'pkfare', $session_key, $input, $session_data);

                $response->Status = true;
                // recent searches table
                // $this->api->db->insert("recent_searches", [
                //     'user_id' => $input['UserId'],
                //     'module' => 'flights',
                //     'search' => json_encode($post_data),
                // ]);

                return [
                    'Status' => true,
                    'Message' => 'results found',
                    "Errors" => [],
                    "Alerts" => [],
                    'Supplier' => [
                        'Name' => 'pkfare',
                        'Key' => $input['SupplierKey'],
                        'SessionKey' => $session_key ?? '',
                    ],
                    "WowSessionKey" => $session_key ?? '',
                    'Flights' => $flights ?? [],
                    'AirportList' => $airport_list ?? [],
                    'AirlineList' => $airline_list ?? [],
                    'CraftList' => $craft_list ?? [],
                ];
            } else {
                $response->status = false;

                $session_data = [
                    'SearchRequest' => $post_data,
                    'SearchResponse' => $response,
                ];
                set_session('flights', 'pkfare', $session_key, $input, $session_data);

                return [
                    'Status' => $response->status ? true : false,
                    'Message' => $response->status ? 'pkfair Search Results success' : 'pkfair Search Results error',
                    "Errors" => $response->errorMsg,
                    "Alerts" => $response->errorMsg,
                    // "TokenId"   => $response['TokenId'],
                    'Supplier' => [
                        'Name' => 'pkfair',
                        'Key' => $input['SupplierKey'],
                        'SessionKey' => $session_key,
                    ],
                    "WowSessionKey" => $session_key,
                    'Flights' => $flights,
                    'CraftList' => $craft_list,
                    'AirportList' => $airport_list,
                    'AirlineList' => $airline_list,
                ];
            }
        } else {
            return [
                'Status' => false,
                'message' => 'Supplier auth failed',
                'data' => [],
            ];
        }
    }
    public function prepare_search_results($response)
    {
        $res_flights = $response->data->flights;
        $res_segments = $response->data->segments;
        $res_solutions = $response->data->solutions;
        $solutions = [];
        foreach ($res_solutions as $skey => $solution) {
            foreach ($solution->journeys as $key => $journey) {
                $solution->journeys->$key = $this->prepare_journey($journey, $res_flights, $res_segments);
            }
            $solutions[] = $solution;
        }
        return $solutions;
    }

    public function prepare_journey($journey, $flights, $segments)
    {
        foreach ($flights as $flight) {
            if ($flight->flightId === $journey[0]) {
                $segment_ids = $flight->segmengtIds;
                $flight->segments = $this->prepare_segments($segment_ids, $segments);
                return $flight;
            }
        }
    }

    public function prepare_segments($segment_ids, $segments)
    {
        $flight_segments = [];
        foreach ($segment_ids as $segment_id) {
            foreach ($segments as $segment) {
                if ($segment->segmentId == $segment_id) {
                    $flight_segments[] = $segment;
                }
            }
        }
        return $flight_segments;
    }

    public function prepare_journeys($flight_journeys)
    {
        $journeys = [];
        foreach ($flight_journeys as $key => $journey) {
            foreach ($journey['segments'] as $segment) {
                $journey_new['airline'] = $segment['airline'];
                $journey_new['arrival'] = $segment['arrival'];
                $journey_new['arrivalDate'] = $segment['strArrivalDate'];
                $journey_new['arrivalTime'] = $segment['strArrivalTime'];
                $journey_new['bookingCode'] = $segment['bookingCode'];
                $journey_new['departure'] = $segment['departure'];
                $journey_new['departureDate'] = $segment['strDepartureDate'];
                $journey_new['departureTime'] = $segment['strDepartureTime'];
                $journey_new['flightNum'] = $segment['flightNum'];
                $journeys[$key][] = $journey_new;
            }
        }
        return $journeys;
    }
    public function array_group_by($array, $key)
    {
        $return = array();
        foreach ($array as $row) {
            $the_key = $row[$key];
            if (!isset($return[$the_key])) {
                $return[$row[$key]] = $row;
            } else {
                $return[$row[$key]]['Options'] = array_merge($return[$row[$key]]['Options'], $row['Options']);
            }
        }
        return $return;
    }
    public function prepare_pricing_journeys($flight_journeys)
    {
        $journeys = [];
        foreach ($flight_journeys as $key => $journey) {
            foreach ($journey['segments'] as $segment) {
                $journey_new['airline'] = $segment['airline'];
                $journey_new['arrival'] = $segment['arrival'];
                $journey_new['arrivalDate'] = $segment['strArrivalDate'];
                $journey_new['arrivalTime'] = $segment['strArrivalTime'];
                $journey_new['bookingCode'] = $segment['bookingCode'];
                $journey_new['departure'] = $segment['departure'];
                $journey_new['departureDate'] = $segment['strDepartureDate'];
                $journey_new['departureTime'] = $segment['strDepartureTime'];
                $journey_new['flightNum'] = $segment['flightNum'];
                $journeys[$key][] = $journey_new;
            }
        }
        return $journeys;
    }
    public function prepare_bags($bags)
    {
        $new_bags = array();
        try {
            foreach ($bags as $key => $bag_list) {
                foreach ($bag_list as $bag) {
                    $new_bag = [
                        'N' => $bag->baggageAmount,
                        'W' => $bag->baggageWeight
                    ];
                    $new_bags[$key][] = $new_bag;
                }
            }
            return $new_bags;
        } catch (Exception $e) {
            return $new_bags;
        }
    }
    public function get_airport($code)
    {
        $airport = Airport::where('code', $code)->first();
        return $airport;
    }
    function flight_segment_duration($segment)
    {
        $strDepartureDate = $segment->strDepartureDate;
        $strDepartureTime = $segment->strDepartureTime;
        $strArrivalDate = $segment->strArrivalDate;
        $strArrivalTime = $segment->strArrivalTime;
        // Convert departure and arrival strings to DateTime objects
        $departureDateTime = DateTime::createFromFormat('Y-m-d H:i', $strDepartureDate . ' ' . $strDepartureTime);
        $arrivalDateTime = DateTime::createFromFormat('Y-m-d H:i', $strArrivalDate . ' ' . $strArrivalTime);

        // Calculate the time difference
        $interval = $arrivalDateTime->diff($departureDateTime);

        // Format the time difference
        $formattedTimeDifference = $interval->format(' %h hours, %i minutes');

        return $formattedTimeDifference;
    }

    function flight_duration($journey, $stops_number)
    {
        // Convert departure and arrival strings to DateTime objects
        $departureDateTime = DateTime::createFromFormat('U', $journey->segments[0]->departureDate / 1000);
        $arrivalDateTime = DateTime::createFromFormat('U', $journey->segments[$stops_number]->arrivalDate / 1000);

        // Calculate the time difference
        $interval = $arrivalDateTime->diff($departureDateTime);

        // Format the time difference
        $formattedTimeDifference = $interval->format(' %h hours, %i minutes');

        return $formattedTimeDifference;
    }
    //================================================== Select Flight functions ====================================================
    public function select_flight($input, $session_data)
    {
        $result_id = $input['Data']['BookingInfo']['ResultId'];
        if (isset($session_data['data']['MappedFlights'][$result_id])) {
            $flight = $session_data['data']['MappedFlights'][$result_id];

            if (isset($input['Data'])) {
                $data = [
                    'Flight' => $flight,
                    'BookingInfo' => $input['Data']['BookingInfo'],
                    'Legs' => $input['Data']['Legs'],
                    'SearchRequest' => $session_data['data']['SearchRequest'],
                    'Info' => [
                        'SupplierKey' => 'pkfare',
                    ],
                ];
                set_session('flights', 'pkfare', $input['WowSessionKey'], null, $data);
            }
            $response = [
                'Success' => true,
                'Message' => 'Select flight response success',
                'Info' => [
                    'SupplierKey' => 'pkfare',
                ],
            ];
        } else {
            $response = [
                'Success' => false,
                'Message' => 'Select flight response failed',
                'Info' => [
                    'SupplierKey' => 'pkfare',
                ],
            ];
        }

        return [
            'status' => true,
            'message' => $response['Success'] ? 'Select flight response success' : 'Select flight response failed',
            'data' => $response,
            'info' => [
                'SupplierKey' => 'pkfare'
            ],
        ];
    }
    //============================================================== Penalty Request =================================================
    public function penalty($flight)
    {
        $post_data = array(
            'authentication' => array(
                'partnerId' => $this->partnerId,
                'sign' => $this->sign,
            ),
            'penalty' => array(
                'journeys' => $flight,
            ),
        );
        $file_name = 'flights_penalty_request.json';
        save_to_file($file_name, 'flights', 'pkfare', $post_data);
        $url_part = 'penalty';
        $request_name = 'penalty';
        $request_method = 'GET';
        $pricing_response = $this->PkFare_sdk->request($url_part, $post_data, $request_name, $request_method);
        $response = json_decode($pricing_response);
        $file_name = 'flights_penalty_response.json';
        save_to_file($file_name, 'flights', 'pkfare', $response);
        return $response;
    }

    public function prepare_penalty_solution(object $pricingResponse)
    {
        $solution = $pricingResponse->data->solution;
        $journeys = (array)$solution->journeys;
        $flights = $pricingResponse->data->flights;
        $parsedJourneys = [];
        foreach ($journeys as $key => $journey) {
            foreach ($flights  as $flight) {
                if ($flight->flightId == $journey[0]) {
                    foreach ($flight->segmentIds as $segmentId) {
                        $segment = $pricingResponse->data->segments[array_search($segmentId, array_column($pricingResponse->data->segments, 'segmentId'))];
                        $parsedJourneys[$key][] = [
                            'airline' => $segment->airline,
                            'flightNum' => $segment->flightNum,
                            'arrival' => $segment->arrival,
                            'arrivalDate' => $segment->strArrivalDate,
                            'arrivalTime' => $segment->strArrivalTime,
                            'departure' => $segment->departure,
                            'departureDate' => $segment->strDepartureDate,
                            'departureTime' => $segment->strDepartureTime,
                            'bookingCode' => $segment->bookingCode
                        ];
                    }
                }
            }
        }

        return [
            'adtFare' => $solution->adtFare,
            'adtTax' => $solution->adtTax,
            'chdFare' => $solution->chdFare,
            'chdTax' => $solution->chdTax,
            'journeys' => $parsedJourneys
        ];
    }

    //============================================================== Pricing Request =================================================
    public function pricing(array $input)
    {
        $response = [];
        $sessionData = get_module_session($input['WowSessionKey']);
        if (!$sessionData) {
            return [
                'status' => false,
                'message' => 'Session Expired !',
            ];
        }

        $sessionCurrency = $sessionData['data']['BookingInfo']['CurrencyCode'];
        $flight = $sessionData['data']['Flight'];
        $searchRequest = $sessionData['data']['SearchRequest'];
        //get pricing
        $pricingResponse = $this->precise_pricing($flight, $searchRequest);
        //get penality
        $penaltyResponse = $this->penalty($this->prepare_penalty_solution($pricingResponse)['journeys']);
        if ($pricingResponse->errorCode !== '0' || $pricingResponse->errorMsg !== 'ok') {
            return [
                'status' => false,
                'message' => 'Error in Pricing request',
            ];
        }
        $solution = $pricingResponse->data->solution;
        $currency = 'USD';
        $amount = ($solution->adtFare ?? 0) + ($solution->adtTax ?? 0) + ($solution->chdFare ?? 0) + ($solution->chdTax ?? 0) + ($solution->chnFare ?? 0) + ($solution->chnTax ?? 0) + ($solution->infFare ?? 0) + ($solution->infTax ?? 0);
        $BookingInfo = $sessionData['data']['BookingInfo'];
        $Flight = $sessionData['data']['Flight'];
        $BookingInfo['Amount'] = $amount;
        $BookingInfo['CurrencyCode'] = $sessionCurrency;
        if (isset($session_data['Flight'])) {
            // Loop over each field in the Flight array
            foreach (['adtFare', 'adtTax', 'chdFare', 'chdTax', 'chnFare', 'chnTax', 'infFare', 'infTax'] as $field) {
                // Check if the field exists in the $solution object
                if (isset($solution->$field)) {
                    // Update the field in the Flight array with the value from the $solution object
                    $Flight[$field] = $solution->$field;
                }
            }
        }

        $data = [
            'Module' => 'flights',
            'Supplier' => 'pkfare',
            'BookingInfo' => $BookingInfo,
            'Flight' => $Flight,
            'Legs' => $sessionData['data']['Legs'],
            'SearchRequest' => $sessionData['data']['SearchRequest'],
        ];
        set_session('flights', 'pkfare', $input['WowSessionKey'], null, $data);
        // $sessionData = get_module_session($input['WowSessionKey']);
        // return $sessionData;
        $response = [
            'status' => true,
            'message' => 'Pricing success',
            'data' => [
                'Legs' => $data['Legs'] ?? [],
                'Penalty' => ($penaltyResponse->errorCode == '0' && $penaltyResponse->errorMsg == 'ok') ? $penaltyResponse->data->penalties : $penaltyResponse->errorMsg,
                'Amount' => $amount,
                'Currency' => $sessionCurrency,
                // 'SearchRequest' => $searchRequest,
                // 'IsLcc' => false,
            ],
        ];
        return $response;
    }

    public function precise_pricing($flight, $searchRequest)
    {
        $solution_key = $flight['solutionKey'];
        $post_data = [
            'authentication' => [
                'partnerId' => $this->partnerId,
                'sign' => $this->sign,
            ],
            'pricing' => [
                'adults' => (int) $searchRequest['AdultCount'],
                'children' => (int) $searchRequest['ChildCount'],
                'solutionKey' => $solution_key,
                'journeys' => $this->prepare_pricing_journeys($flight['journeys']),
            ],
        ];
        $file_name = 'flights_PrecisePricing_request.json';
        save_to_file($file_name, 'flights', 'pkfare', $post_data);
        $url_part = 'precisePricing_V2';
        $request_name = 'PrecisePricing';
        $request_method = 'GET';
        $pricing_response = $this->PkFare_sdk->request($url_part, $post_data, $request_name, $request_method);
        $response = json_decode($pricing_response);
        $file_name = 'flights_PrecisePricing_response.json';
        save_to_file($file_name, 'flights', 'pkfare', $response);
        return $response;
    }

    //============================================================== Create Booking ==========================================
    public function create_booking($input)
    {
        // Validate input parameters
        if (!isset($input['WowSessionKey'], $input['UserCredits'], $input['CountryCode'], $input['Passengers'])) {
            return json_response([
                'message' => 'Error in Booking request: validate input parameters',
                'status' => false
            ], 200);
        }
        // Pre-book the flight and log the response
        try {
            $post_data = $this->pre_book($input);
        } catch (Exception $e) {
            throw new \Exception('Error in Pre-Booking request , ' . $e->getMessage());
        }
        // Send the book request using the pkfare SDK and log the response
        $bookingResponse = $this->precise_booking($post_data);

        if ($bookingResponse->errorCode !== '0' || $bookingResponse->errorMsg !== 'ok') {
            throw new \Exception('Error in Booking request , ' . $bookingResponse->errorMsg);
        }

        $sessionData = get_module_session($input['WowSessionKey']);

        if (!$sessionData) {
            throw new \Exception('Error in Booking request : No session data');
        }

        $userCredits = $input['UserCredits'];
        // $userNetAmount = $userCredits->credit_amount - $this->add_markup($sessionData['BookingInfo']['Amount']);
        //TODO add markup
        $userNetAmount = $userCredits->credit_amount;

        if ($userNetAmount < $userCredits->credit_allowed_amount) {
            throw new \Exception('Error in Booking request : There\'s no enought balance');
        }

        // Insert new booking
        $bookingData = [
            'customer_id' => $input['UserId'] ?? 0,
            'company_id' => request()->agent->id,
            'session_key' => $input['WowSessionKey'],
            'supplier_session_id' => $sessionData["SupplierSessionKey"],
            'booking_status' => 'PNR Created',
            'supplier_name' => 'pkfare',
            'supplier_id' => get_supplier_id('pkfare'),
            'amount' => $sessionData['data']['BookingInfo']['Amount'], //apply markup
            'original_amount' => $sessionData['data']['BookingInfo']['Amount'], //apply markup
            'currency_code' => $sessionData['data']['BookingInfo']['CurrencyCode'],
            // 'payment_id' => 'Pending',
            'pnr' => $bookingResponse->data->pnr,
            'customer_id' => $input['CustomerId'],
            'booking_details' => [
                'name' => $input['LeadGuest']['first_name'] . '/' . $input['LeadGuest']['last_name'],
                'email' => $input['LeadGuest']['email'],
                'telNum' => $input['LeadGuest']['mobile']['full_number'],
                'PNR' => $bookingResponse->data->pnr,
                'orderNum' => $bookingResponse->data->orderNum,
                'BookingInfo' => $sessionData['data']['BookingInfo'],
                'adult_count' => $sessionData['data']['SearchRequest']['AdultCount'],
                'child_count' => $sessionData['data']['SearchRequest']['ChildCount'],
                'infant_count' => $sessionData['data']['SearchRequest']['InfantCount'],
                'ip_address' => $input['IpAddress'],
                'country_code' => $input['CountryCode'],
                'Booking' => [
                    'Request' => $post_data,
                    'Response' => $bookingResponse
                ],
                'BookingNeededInfo' => [
                    'Supplier' => 'pkfare',
                    // 'SupplierSessionKey' => $input['SupplierSessionKey'],
                    'SearchRequest' => $sessionData['data']['SearchRequest'],
                    'Flight' => $sessionData['data']['Flight'],
                    'Legs' => $sessionData['data']['Legs'],
                    'BookingInfo' => $sessionData['data']['BookingInfo'],
                ],
            ],
        ];
        $booking = FlightsBookingList::create($bookingData);
        if (!$booking) {
            throw new \Exception('Error in Booking request : Can\'t save booking data');
        }
        $bookingId = $booking->id;

        $bookingData = [
            'UserId' => $input['UserId'],
            'BookingId' => $bookingId,
            'SupplierName' => 'pkfare',
            'MerchantRef' => $bookingId . '.' . $input['UserId'],
            'PaymentInfo' => [
                'Ref' => $bookingId . '.' . $input['UserId'],
                'Price' => [
                    'NetAmount' => $sessionData['data']['BookingInfo']['Amount'],
                    //TODO add markup
                    // 'SaleAmount' => $this->add_markup($sessionData['data']['BookingInfo']['Amount']),
                    'Currency' => $sessionData['data']['BookingInfo']['CurrencyCode'],
                ],
                'Credit' => [
                    'AvailableForPay' => $userNetAmount >= $userCredits->credit_allowed_amount,
                    'UserCredits' => $userCredits->credit_amount,
                    'CreditCurrency' => 'USD',
                ],
            ],
        ];
        return $bookingData;
    }

    public function prepare_solution(object $pricingResponse)
    {
        $solution = $pricingResponse->data->solution;
        $journeys = (array)$solution->journeys;
        $flights = $pricingResponse->data->flights;
        $parsedJourneys = [];
        foreach ($journeys as $key => $journey) {
            $segmentsMap = [];
            $flight = $flights[array_search($journey, array_column($flights, 'flightId'))];
            foreach ($flight->segmentIds as $segmentId) {
                $segment = $pricingResponse->data->segments[array_search($segmentId, array_column($pricingResponse->data->segments, 'segmentId'))];
                $segmentsMap[] = [
                    'airline' => $segment->airline,
                    'flightNum' => $segment->flightNum,
                    'arrival' => $segment->arrival,
                    'arrivalDate' => $segment->strArrivalDate,
                    'arrivalTime' => $segment->strArrivalTime,
                    'departure' => $segment->departure,
                    'departureDate' => $segment->strDepartureDate,
                    'departureTime' => $segment->strDepartureTime,
                    'bookingCode' => $segment->bookingCode
                ];
            }
            $parsedJourneys[$key] = $segmentsMap;
        }

        return [
            'adtFare' => $solution->adtFare,
            'adtTax' => $solution->adtTax,
            'chdFare' => $solution->chdFare,
            'chdTax' => $solution->chdTax,
            'journeys' => $parsedJourneys
        ];
    }

    public function prepare_ancillaries($response, $passengers)
    {
        // $this->api->response($response);
        $json = [
            "ancillaryPassenger" => [
                "firstName" => $passengers[0]['first_name'],
                "lastName" => $passengers[0]['last_name'],
                "psgType" => "ADT"
            ],
            "ancillaries" => [
                "baggage" => [
                    [
                        "ancillaryKey" => $response->data[0]->ancillary->ancillaries->baggage[0]->ancillaryKey,
                        "payBaggageType" => $response->data[0]->ancillary->ancillaries->baggage[0]->payBaggageType,
                        "baggagePiece" => $response->data[0]->ancillary->ancillaries->baggage[0]->baggagePiece,
                        "baggageWeight" => $response->data[0]->ancillary->ancillaries->baggage[0]->baggageWeight,
                        "baggageCurrency" => $response->data[0]->ancillary->ancillaries->baggage[0]->baggageCurrency,
                        "baggagePrice" => $response->data[0]->ancillary->ancillaries->baggage[0]->baggagePrice,
                        "ancillaryJourneys" => $response->data[0]->ancillary->journeys[0]
                    ]
                ]
            ]
        ];
        return $json;
    }

    //prebook
    public function pre_book(array $input)
    {
        // Log the start of the function.
        $data = [
            'user_id' => $input['UserId'],
            'company_id' => request()->agent->id,
            'module' => 'flights',
            'supplier' => 'pkfare',
            'content' => [
                'location' => 'pre_book_beginning',
                'data' => $input,
            ],
        ];
        store_logs($data);

        // Initialize the post data.
        $post_data = [];
        // Check if there is a valid session.
        if ($sessionData = get_module_session($input['WowSessionKey'])) {
            $flight = $sessionData['data']['Flight'];
            // $ancillaryPricingResponse = $this->ancillary_pricing($this->prepare_journeys($flight['journeys']), $sessionData['SearchRequest']);
            // Get the pricing response.
            $pricingResponse = $this->precise_pricing($flight, $sessionData['data']['SearchRequest']);

            if ($pricingResponse->errorCode !== '0' || $pricingResponse->errorMsg !== 'ok') {
                throw new \Exception('Error in Pricing request : ' . $pricingResponse->errorMsg);
            }
            // Get the passenger data.
            $passengers = $input['Passengers'];
            // Log the start of the function.
            $data = [
                'user_id' => $input['UserId'],
                'company_id' => request()->agent->id,
                'module' => 'flights',
                'supplier' => 'pkfare',
                'content' => [
                    'location' => 'pre_book_inside_session_data',
                    'data' => $flight,
                ],
            ];
            store_logs($data);

            // Prepare the post data.


            // if ($ancillaryPricingResponse->errorCode == '0' || $ancillaryPricingResponse->errorMsg == 'ok') {
            //     $post_data = [
            //         'authentication' => [
            //             'partnerId' => $this->PartnerID,
            //             'sign' => $this->Sign,
            //         ],
            //         'booking' => [
            //             'passengers' => $this->prepare_passengers($passengers),
            //             'ancillary' =>  $this->prepare_ancillaries($ancillaryPricingResponse, $passengers),
            //             'solution' => $this->prepare_solution($pricingResponse)
            //         ],
            //     ];
            // } else {
            $post_data = [
                'authentication' => [
                    'partnerId' => $this->partnerId,
                    'sign' => $this->sign,
                ],
                'booking' => [
                    'passengers' => $this->prepare_passengers($passengers),
                    'solution' => $this->prepare_penalty_solution($pricingResponse)
                ],
            ];
            // }

            // Log the start of the function.
            $data = [
                'user_id' => $input['UserId'],
                'company_id' => request()->agent->id,
                'module' => 'flights',
                'supplier' => 'pkfare',
                'content' => [
                    'location' => 'pre_book_after_post_data',
                    'data' => $post_data,
                ],
            ];
            store_logs($data);
            // Set the book request in the session.
            // $merged_data = array_merge($sessionData['data'], ['BookRequest' => $post_data]);
            // set_session('flights', 'pkfare', $input['WowSessionKey'], [
            //     $merged_data,
            // ]);
        }
        // Return the post data.
        return $post_data;
    }

    //precise booking
    public function precise_booking($post_data)
    {
        $file_name = 'flights_PreciseBooking_request.json';
        save_to_file($file_name, 'flights', 'pkfare', $post_data);
        $url_part = 'preciseBooking_V2';
        $request_name = 'preciseBooking_V2';
        $request_method = 'GET';
        $bookingResponse = $this->PkFare_sdk->request($url_part, $post_data, $request_name, $request_method);
        $response = json_decode($bookingResponse);
        $file_name = 'flights_PreciseBooking_response.json';
        save_to_file($file_name, 'flights', 'pkfare', $response);
        return $response;
    }

    //prepare passengers
    public function prepare_passengers($passengers)
    {
        $new_passengers = [];
        foreach ($passengers as $passenger) {
            $new_passenger['firstName'] = $passenger['first_name'];
            $new_passenger['lastName'] = $passenger['last_name'];
            $new_passenger['psgType'] = $passenger['type'] == 'adult' ? 'ADT' : 'CHD';
            $new_passenger['sex'] = $passenger['title'] == 'MR' ? 'M' : 'F';
            $new_passenger['birthday'] = $passenger['birthday']['year'] . '-' . $passenger['birthday']['month'] . '-' . $passenger['birthday']['day'];
            $new_passenger['nationality'] = 'PH';
            //not required
            $new_passenger['cardType'] = 'P';
            $new_passenger['cardNum'] = '451220002115487';
            $new_passenger['cardExpiredDate'] = '2025-7-7';

            $new_passengers[] = $new_passenger;
        }
        return $new_passengers;
    }

    //============================================================== Create Order Request ==========================================

    public function create_order($input)
    {
        $orderPricingResponse = $this->order_pricing($input['orderNum']);

        $data = [
            'module' => 'flights',
            'supplier' => 'pkfare',
            'content' => [
                'location' => 'booking_request_order_pricing_request',
                'ticket_response' => $orderPricingResponse
            ]
        ];

        store_logs($data);

        if ($orderPricingResponse->errorCode !== '0' || $orderPricingResponse->errorMsg !== 'ok') {
            throw new \Exception('Error in Order Pricing request : ' . $orderPricingResponse->errorMsg);
        }

        // Ticket the booking
        $ticketResponse = $this->ticketing_request($input);

        $data = [
            'module' => 'flights',
            'module' => 'flights',
            'supplier' => 'pkfare',
            'content' => [
                'location' => 'booking_request_after_ticket_request',
                'ticket_response' => $ticketResponse
            ]
        ];

        store_logs($data);

        if ($ticketResponse->errorCode !== '0' || $ticketResponse->errorMsg !== 'ok') {
            throw new \Exception('Error in Tiketing request : ' . $ticketResponse->errorMsg);
        }

        $bookingData = $input['booking'];
        if ($bookingData) {
            $bookingData->update([
                'booking_status' => 'Confirmed',
                'ticket' => $ticketResponse
            ]);
        }

        return [
            'status' => true,
            'message' => 'Ticketing successful',
            'TicketResponse' => $ticketResponse,
            'PNR' => $input['pnr']
        ];
    }

    //============================================================== Order Pricing ==========================================

    public function order_pricing($orderNum)
    {
        $post_data = [
            'authentication' => [
                'partnerId' => $this->partnerId,
                'sign' => $this->sign,
            ],
            'orderPricing' => [
                "orderNum" => $orderNum,
            ],
        ];

        $file_name = 'flights_orderPricing_request.json';
        save_to_file($file_name, 'flights', 'pkfare', $post_data);
        $url_part = 'orderPricingV2';
        $request_name = 'orderPricingV2';
        $request_method = 'GET';
        $orderPricingResponse = $this->PkFare_sdk->request($url_part, $post_data, $request_name, $request_method);
        $response = json_decode($orderPricingResponse);
        $file_name = 'flights_orderPricing_response.json';
        save_to_file($file_name, 'flights', 'pkfare', $response);
        return $response;
    }

    //============================================================== Order Ticketing ==========================================
    public function ticketing_request($input)
    {
        $postData = [
            'authentication' => [
                'partnerId' => $this->partnerId,
                'sign' => $this->sign,
            ],
            'ticketing' => [
                "email" => $input['email'],
                "name" => $input['name'],
                "orderNum" => $input['orderNum'],
                "telNum" => $input['telNum'],
                "PNR" => $input['pnr']
            ]
        ];
        $fileName = 'flights_ticketing_request.json';
        save_to_file($fileName, 'flights', 'pkfare', $postData);
        $urlPart = 'ticketing';
        $requestName = 'ticketing';
        $requestMethod = 'GET';
        $ticketingResponse = $this->PkFare_sdk->request($urlPart, $postData, $requestName, $requestMethod);
        $response = json_decode($ticketingResponse);
        $fileName = 'flights_ticketing_response.json';
        save_to_file($fileName, 'flights', 'pkfare', $response);
        return $response;
    }

    //============================================================== Ticket Request ================================================
    public function TicketingNumPush($postData)
    {
        // $this->api->response($postData);
        // die;
        $fileName = 'flights_TicketingNumPush_V3_request.json';
        file_put_contents($fileName, json_encode($postData));
        $urlPart = 'TicketingNumPush_V3';
        $requestName = 'TicketingNumPush_V3';
        $requestMethod = 'POST';
        $TicketingNumPushResponse = $this->PkFare_sdk->request($urlPart, $postData, $requestName, $requestMethod);
        $response = json_decode($TicketingNumPushResponse);
        $fileName = 'flights_TicketingNumPush_V3_response.json';
        file_put_contents($fileName, json_encode($response));
        return $response;
    }
    public function ticket($input)
    {
        $errors = [];
        $data = [];
        $messages = [];

        // Check if session is expired
        $session_data = $this->api->wow_sessions->get_module_session($input['WowSessionKey']);
        if (!$session_data) {
            $errors[] = 'Session expired';
            return [
                'status' => false,
                'message' => $errors,
                'data' => $input['MerchantRef']
            ];
        }

        $booking = $input['Booking'];
        $booking_id = $booking->booking_id;
        $merchant_ref = $booking_id . '.' . $booking->user_id;

        //get the booking again
        $booking = $this->api->db->where('booking_id', $booking_id)->get('flights_booking_list')->row();
        $input['Booking'] = $booking;
        $booking_details = json_decode($booking->booking_details, TRUE);

        if ($input['PNR'] != null) {
            $post_data = [
                "email" => $input['email'],
                "name" => $input['name'],
                "orderNum" => $input['orderNum'],
                "telNum" => $input['telNum'],
                "PNR" => $input['PNR']
            ];
        }
        $response = $this->ticketing_request($post_data);

        $this->api->response($response);
        die;

        if (isset($response['Errors']) && count($response['Errors'])) {
            foreach ($response['Errors'] as $e) {
                $errors[] = $e['UserMessage'];
            }
        }
        $booking_details['Ticket']['Request'] = $post_data;
        $booking_details['Ticket']['Response'] = $response;
        $response['Supplier'] = 'pkfare';
        if (isset($response['IsSuccess']) && $response['IsSuccess']  && isset($response['Status']) && $response['Status'] == 1) {
            $session_data['TicketRequest'] =  $post_data;
            $session_data['TicketResponse'] = $response;
            $this->api->wow_sessions->set_module_session('flights', 'tboair', $input['WowSessionKey'], $session_data);

            $success = TRUE;
            $messages[] = 'Ticket response success';

            // $flight = $session_data['Flight'];
            $flight = $booking_details['BookingNeededInfo']['Flight'];
            foreach ($flight['Segments'] as $k => $leg) {
                // needed data to fill in database are (airline departure, arrival, departure_date, pnr, leg_details)
                // search for existing legs first
                if (!$this
                    ->api->db
                    ->where('departure', $leg[0]['Origin']['AirportCode'])
                    ->where('arrival', $leg[(count($leg)) - 1]['Destination']['AirportCode'])
                    ->where('booking_id', $booking_id)
                    ->get('flights_legs')
                    ->result()) {
                    $this
                        ->api->db
                        ->insert('flights_legs', [
                            'user_id'   =>   $input['UserId'],
                            'booking_id'   =>   $booking_id,
                            'wow_session_key'   =>  $input['WowSessionKey'],
                            'wow_session_id'   =>  $input['WowSessionKey'],
                            'supplier_session_key'  => $session_data["TrackingId"],
                            'pnr'   =>  $response['Itinerary']['PNR'],
                            'airline'   =>  $leg[0]['Airline'],
                            'departure' =>  $leg[0]['Origin']['AirportCode'],
                            'arrival'   =>  $leg[(count($leg)) - 1]['Destination']['AirportCode'],
                            'departure_date'    =>  $leg[0]['DepartureTime'],
                            'leg_details'   =>  json_encode($leg)
                        ]);
                }
            }

            //flights_travellers table
            $passengers = [];
            foreach ($response['Itinerary']['Passenger'] as $passenger) {
                $passengers[] = $passenger;
                if ($passenger['Ticket']) {
                    if ($passenger['Ticket']['Status'] == 'OK' && $passenger['Ticket']['TicketNumber'] != null && $passenger['Ticket']['TicketNumber'] != '') {
                        // update passengers table
                        if (!$existing_passenger = $this
                            ->api->db
                            ->where('booking_id', $booking_id)
                            ->where('surname', $passenger['Title'])
                            ->where('first_name', $passenger['FirstName'])
                            ->where('last_name', $passenger['LastName'])
                            ->where('nid_number', $passenger['PassengerIdNo'])
                            ->get('flights_travellers')
                            ->result()) {
                            switch ($passenger['Type']) {
                                case 1:
                                    $passenger_type = 'ADT';
                                    break;
                                case 2:
                                    $passenger_type = 'CHD';
                                    break;
                                case 3:
                                    $passenger_type = 'INF'; // !IMPORTANT TO DOUBLE CHECK
                                    break;
                            }

                            $this
                                ->api->db
                                ->insert('flights_travellers', [
                                    'user_id'   =>   $input['UserId'],
                                    'booking_id'   =>   $booking_id,
                                    'surname'   => $passenger['Title'],
                                    'first_name'    => $passenger['FirstName'],
                                    'last_name' => $passenger['LastName'],
                                    'nid_number'    => $passenger['PassengerIdNo'],
                                    'type'  =>  $passenger_type,
                                    'details'   =>  json_encode($passenger),
                                    'ticket_number' =>  $passenger['Ticket']['TicketNumber'],
                                    'ticket_status' =>  $passenger['Ticket']['Status'],
                                    'ticket_details'    =>  json_encode($passenger['Ticket'])
                                ]);

                            $passenger_id = $this->api->db->insert_id();
                        }

                        // search for travellers get id from travellers table
                        elseif ($existing_passenger = $this
                            ->api->db
                            ->where('booking_id', $booking_id)
                            ->where('surname', $passenger['Title'])
                            ->where('first_name', $passenger['FirstName'])
                            ->where('last_name', $passenger['LastName'])
                            ->where('nid_number', $passenger['PassengerIdNo'])
                            ->get('flights_travellers')
                            ->result()
                        ) {
                            $passenger_id = $existing_passenger[0]->id;

                            $this
                                ->api->db
                                ->where('id', $passenger_id)
                                ->update('flights_travellers', [
                                    'ticket_number' =>  $passenger['Ticket']['TicketNumber'],
                                    'ticket_status' =>  $passenger['Ticket']['Status'],
                                    'ticket_details'    =>  json_encode($passenger['Ticket'])
                                ]);
                        }

                        // get legs of booking_id
                        $booking_legs = $this->api->db
                            ->where('booking_id', $booking_id)
                            ->get('flights_legs')
                            ->result();

                        foreach ($booking_legs as $booking_leg) {
                            // update tickets table
                            $this
                                ->api->db
                                ->insert('flights_tickets', [
                                    'booking_id'    =>  $booking_id,
                                    'traveller_id'  =>  $passenger_id,
                                    'leg_id'        =>  $booking_leg->leg_id,
                                    'ticket_number' =>  $passenger['Ticket']['TicketNumber'],
                                    'ticket_status' =>  $passenger['Ticket']['Status'],
                                    'ticket_details'    =>  json_encode($passenger['Ticket'])
                                ]);
                        }

                        //!update ticket_status in flights_booking_list
                        $this->api->db
                            ->where('booking_id', $booking_id)
                            ->update('flights_booking_list', [
                                'ticket_status' =>  'True' //string
                            ]);
                    }
                }
            }
            // update flights_booking_list table
            // $booking_details = json_decode($booking->booking_details, TRUE);

            if ($input['IsLcc']) // Lcc then ticket request will be send without pnr
            {
            }

            $booking_details['PNR'] = $response['PNR'];
            $booking_details['Passengers'] = $passengers;

            $this
                ->api->db
                ->where('booking_id', $booking_id)
                ->update('flights_booking_list', [
                    'booking_details' =>  json_encode($booking_details),
                    'booking_status' =>  'Ticketed',
                    'pnr'    =>  $response['PNR']
                ]);
        } elseif (isset($response['IsSuccess']) && $response['IsSuccess'] && isset($response['Status']) && $response['Status'] == 5) {
            $success = false;
            $errors[] = 'Ticket response InProgress = 5';

            $booking_details['Ticket']['Response'] = $response;
            //update db
            $this->api->db
                ->where('booking_id', $booking_id)
                ->update('flights_booking_list', [
                    'ticket_status' =>  'InProgress',
                    'booking_details'   =>  json_encode($booking_details)
                ]);

            if (!$existing_cron = $this->api->db
                ->where('merchant_ref', $merchant_ref)
                ->where('module', 'flights')
                ->where('supplier', 'tboair')
                ->get('cron')
                ->row()) {
                $cron_url = 'https://backoffice.wowws.net/api/module/flights/cron?merchant_ref=' . $merchant_ref . '&access_token=9606c279-2582-40af-8721-7d2541e0d442'; //!url to be set

                // add cron to crontab
                $cron_command = '(crontab -l 2>/dev/null || true; echo "0 * * * * wget ' . $cron_url . '") | crontab -';
                exec($cron_command);
                // djson($output, $return_value);
                $del = 'crontab -l 2>/dev/null | grep -v "wget ' . $cron_url . '"  | crontab -'; //!remove cron

                $this->api->db
                    ->insert('cron', [
                        'user_id'   =>  $input['UserId'],
                        'booking_id'    =>  $booking_id,
                        'merchant_ref'  =>  $merchant_ref,
                        'unique_key'    =>  $response['PNR'],
                        'url'           =>  $cron_url, //cron url
                        'command'       =>  $cron_command,
                        'module'        =>  'flights',
                        'supplier'      =>  'tboair',
                        'runs'          =>  10,
                        'active'        =>  1,
                    ]);
            }
        } elseif (isset($response['IsSuccess']) && $response['IsSuccess'] && isset($response['Status']) && $response['Status'] == 8) {
            /**
             * PriceChanged = 8 (Fare has been changed and request to share the updated fare in the ticket request for the successful booking)
             */
            $success = false;
            $errors[] = 'Ticket response PriceChanged = 8 (Fare has been changed and request to share the updated fare in the ticket request for the successful booking)';
        } elseif (isset($response['IsSuccess']) && $response['IsSuccess'] && isset($response['Status']) && $response['Status'] == 12) {
            /**
             * Cancelled = 12 (Cancelled the ticket)
             */
            $success = false;
            $errors[] = 'Ticket response Cancelled = 12 (Cancelled the ticket)';
        } elseif (isset($response['IsSuccess']) && !$response['IsSuccess'] && isset($response['Errors'][0]['Code']) && $response['Errors'][0]['Code'] == 29) {
            $regex = '/([A-Z0-9]{6,10})/';
            $string = $response['Errors'][0]['UserMessage'];
            preg_match($regex, $string, $pnrs);
            // if(strstr($response['Errors'][0]['UserMessage'], "PNR Details:"))
            if (count($pnrs)) {

                $input['PNR'] = $pnrs[0];
                $data['PNR'] = $input['PNR'];
                // dpre($input);
                $input['UpdateDatabase'] = true;
                $booking_details_response = $this->booking_details($input);
                // $booking_details_response = $booking_details_response['data'];
                if (isset($booking_details_response['data']['Errors']) && count($booking_details_response['data']['Errors'])) {
                    foreach ($booking_details_response['data']['Errors'] as $e) {
                        $errors[] = $e['UserMessage'];
                    }
                }
                if (isset($booking_details_response['data']['IsSuccess']) && $booking_details_response['data']['IsSuccess'] && isset($booking_details_response['data']['Status']) && $booking_details_response['data']['Status'] == 2) {
                    $success = true;
                    $messages[] = $booking_details_response['message'];
                    $booking_details_response['Success'] = TRUE;

                    $session_data['BookingDetailsResponse'] = $booking_details_response;
                    $this->api->wow_sessions->set_module_session('flights', 'tboair', $input['WowSessionKey'], $session_data);

                    if ($existing_booking = $this
                        ->api->db
                        ->where('booking_id', $booking_id)
                        ->get('flights_booking_list')
                        ->result()
                    ) {

                        $booking_details = json_decode($booking->booking_details, true);
                        $flight = $booking_details['Flight'];
                        $legs_ids = [];
                        foreach ($flight['Segments'] as $leg) {

                            if (!$this
                                ->api->db
                                ->where('booking_id', $booking_id)
                                ->where('departure', $leg[0]['Origin']['AirportCode'])
                                ->where('arrival', $leg[0]['Destination']['AirportCode'])
                                ->get('flights_legs')
                                ->result()) {
                                $this
                                    ->api->db
                                    ->insert('flights_legs', [
                                        'user_id'   =>   $input['UserId'],
                                        'booking_id'   =>   $booking_id,
                                        'wow_session_key'   =>  $input['WowSessionKey'],
                                        'wow_session_id'   =>  $input['WowSessionKey'],
                                        'supplier_session_key'  => $session_data["TrackingId"],
                                        'pnr'   =>  $input['PNR'],
                                        'airline'   =>  $leg[0]['Airline'],
                                        'departure' =>  $leg[0]['Origin']['AirportCode'],
                                        'arrival'   =>  $leg[(count($leg)) - 1]['Destination']['AirportCode'],
                                        'departure_date'    =>  $leg[0]['DepartureTime'],
                                        'leg_details'   =>  json_encode($leg)
                                    ]);
                                $legs_ids[] = $this->api->db->insert_id();
                            }
                        }

                        $passengers = [];
                        foreach ($session_data['BookingDetailsResponse']['Itinerary']['Passenger'] as $traveller) {
                            $passengers[] = $traveller;
                            // search for existing legs first
                            if (!$this
                                ->api->db

                                ->where('booking_id', $booking_id)
                                ->where('user_id', $input['UserId'])
                                ->where('surname', $traveller['Title'])
                                ->where('first_name', $traveller['FirstName'])
                                ->where('last_name', $traveller['LastName'])
                                ->where('nid_number', $traveller['PassengerIdNo'])
                                ->get('flights_travellers')
                                ->result()) {
                                switch ($traveller['Type']) {
                                    case 1:
                                        $traveller_type = 'ADT';
                                        break;
                                    case 2:
                                        $traveller_type = 'CHD';
                                        break;
                                    case 3:
                                        $traveller_type = 'INF'; // !IMPORTANT TO CHECK
                                        break;
                                }
                                $this
                                    ->api->db
                                    ->insert('flights_travellers', [
                                        'user_id'   =>   $input['UserId'],
                                        'booking_id'   =>   $booking_id,
                                        'surname'   => $traveller['Title'],
                                        'first_name'    => $traveller['FirstName'],
                                        'last_name' => $traveller['LastName'],
                                        'nid_number'    => $traveller['PassengerIdNo'],
                                        'type'  =>  $traveller_type
                                    ]);
                            }

                            $passenger_id = $this->api->db->insert_id();

                            if ($traveller['Ticket']['Status'] == 'OK' && $traveller['Ticket']['TicketNumber'] != null && $traveller['Ticket']['TicketNumber'] != '') {
                                // get legs of booking_id
                                $booking_legs = $this->api->db
                                    ->where('booking_id', $booking_id)
                                    ->get('flights_legs')
                                    ->result();

                                foreach ($booking_legs as $booking_leg) {
                                    // update tickets table
                                    $this
                                        ->api->db
                                        ->insert('flights_tickets', [
                                            'booking_id'    =>  $booking_id,
                                            'traveller_id'  =>  $passenger_id,
                                            'leg_id'        =>  $booking_leg->leg_id,
                                            'ticket_number' =>  $traveller['Ticket']['TicketNumber'],
                                            'ticket_status' =>  $traveller['Ticket']['Status'],
                                            'ticket_details'    =>  json_encode($traveller['Ticket'])
                                        ]);
                                }
                                $this->api->db
                                    ->where('booking_id', $booking_id)
                                    ->update('flights_booking_list', [
                                        'ticket_status' =>  'True' //string
                                    ]);
                            }
                        }
                        $booking_details['PNR'] = $input['PNR'];

                        if ($input['IsLcc']) // Lcc then ticket request will be send without pnr
                        {
                        }

                        $booking_details['Passengers'] = $passengers;

                        // flights_booking_list table
                        $this
                            ->api->db
                            ->where('booking_id', $booking_id)
                            ->update('flights_booking_list', [
                                'booking_status'    =>  'Ticketed',
                                'booking_details'   =>  json_encode($booking_details),
                                'pnr'   =>  $input['PNR'],
                                'ip_address'    =>  $this->api->input->ip_address()
                            ]);
                        // }
                    } else {
                        $success = false;
                        $errors[] = 'No such booking id found in DB';
                        $response['Success'] = FALSE;
                    }
                    $response = $booking_details_response;
                } else {
                    $success = FALSE;
                    $errors[] = $booking_details_response['message'];
                    $booking_details_response['Success'] = false;
                }
            } else {
                $success = FALSE;
                $errors[] = 'PNR error';
            }
        } else {
            $success = false;
            $errors[] = 'Ticket response Unknown error';
        }
        return [
            'status' => $success ? TRUE : FALSE,
            'message' => $success ? $messages : $errors,
            'data' => $response,
        ];
    }

    //============================================================== Order Details ================================================

    public function order_details($orderNum)
    {
        $post_data = [
            'authentication' => [
                'partnerId' => $this->partnerId,
                'sign' => $this->sign,
            ],
            'data' => [
                "orderNum" => $orderNum,
                "includeFields" => "passengers,journeys,solutions"
            ],
        ];

        $file_name = 'flights_orderDetails_request.json';
        save_to_file($file_name, 'flights', 'pkfare', $post_data);

        $url_part = 'orderDetail/v5';
        $request_name = 'orderDetail/v5';
        $request_method = 'GET';
        $response = $this->PkFare_sdk->request($url_part, $post_data, $request_name, $request_method);
        $file_name = 'flights_orderDetails_response.json';
        save_to_file($file_name, 'flights', 'pkfare', $post_data);
        return json_decode($response);
    }
    //============================================================= ticketNum Push ===================================================
    public function ticket_push(Request $request)
    {
        $order_num = $request->orderNum;
        $booking = FlightsBookingList::where('order_num', $order_num)->first();
        if (!$booking) {
            return json_response(['status' => false, 'message' => 'Can\'t find order'], 200);
        }
        $booking->update(
            ['ticket' => $request->all(), 'booking_status' => 'Ticketed']
        );
        return json_response(['status' => true, 'message' => 'ticket added successfully'], 200);
    }
}
