<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\Flights\Http\Controllers\FlightsController;
use Modules\Flights\Http\Controllers\PkfareController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware(['agent_auth'])->prefix('modules/flights')->group(function () {
    Route::get('/auto_complete/{q}', [FlightsController::class, 'auto_complete']);
    Route::post('/search', [FlightsController::class, 'search']);
    Route::post('/select_flight', [FlightsController::class, 'select_flight']);
    Route::post('/pricing', [FlightsController::class, 'pricing']); 
    Route::post('/book', [FlightsController::class, 'book']);
    Route::post('/pay_from_balance/{merchantReference}', [FlightsController::class, 'pay_from_balance']);
    Route::get('/booking_details/{merchantReference}', [FlightsController::class, 'booking_details']);
    Route::get('/pre_payment/{merchantReference}', [FlightsController::class, 'pre_payment']);
    Route::get('/payment_details/{merchantReference}', [FlightsController::class, 'payment_details']);
    Route::get('/local_booking_details/{merchantReference}', [FlightsController::class, 'local_booking_details']);
});
Route::post('modules/flights/pkfare/ticket_push', [PkfareController::class, 'ticket_push']);
