<?php

namespace Modules\Hotels\Entities;

use App\Models\Customer;
use App\Models\Supplier;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\StaticData\Entities\Hotel;

class HotelsBookingList extends Model
{
    use HasFactory;
    protected $table = 'hotels_booking_list';

    protected $fillable = [
        'customer_id',
        'company_id',
        'confirmation_number',
        'booking_status',
        'invoice_number',
        'payment_status',
        'voucher_status',
        'amount',
        'original_amount',
        'currency_code',
        'supplier_ref_number',
        'trip_name',
        'requested_client_ref_number',
        'booking_description',
        'amendment_status',
        'supplier_id',
        'hotel_id',
        'hotel_name',
        'hotel_rating',
        'city_code',
        'city_name',
        'to_date',
        'from_date',
        'last_cancellation_deadline',
        'current_cancellation_charge',
        'rooms_number',
        'rooms_type_name',
        'booking_date',
        'booking_details',
        'supplier_booking_id',
        'payment_deadline',
        'is_deleted',
        'adult_count',
        'child_count',
        'infant_count',
        'country_code',
        'mobile',
        'email',
        'ip_address',
    ];

    protected $casts = [
        'booking_details' => 'array',
        'rooms_type_name' => 'array',
    ];
    protected $appends = ['hotel', 'user','company','supplier',];

    public function getHotelAttribute()
    {
        $hotel = Hotel::find($this->attributes['hotel_id']);
        return $hotel ? $hotel : null;
    }

    public function getUserAttribute()
    {
        $user = Customer::find($this->attributes['customer_id']);
        return $user ? $user : null;
    }
    public function getCompanyAttribute()
    {
        $company = User::with('balance')->find($this->attributes['company_id']);
        return $company ? $company : null;
    }
    public function getSupplierAttribute()
    {
        $supplier = Supplier::find($this->attributes['supplier_id']);
        return $supplier ? $supplier : null;
    }
}
