<?php

namespace Modules\Hotels\Http\Controllers\SDK\Dotw;

use Exception;
use GuzzleHttp\Client;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use GuzzleHttp\Psr7\Request as guzzleRequest;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Handler\CurlHandler;
use Illuminate\Support\Facades\Crypt;

class DotwsdkController extends Controller
{
    private $loginId;
    private $password;
    private $companyCode;
    private $currency = '492'; //SAR
    // private $currency = '520'; //USD
    private $mode = 'test'; //test prod
    private $base_url = [
        'test' => 'https://xmldev.dotwconnect.com',
        'prod' => 'https://us.DOTWconnect.com',
    ];
    private $api_version = '/gatewayV4.dotw';

    public function __construct($settings)
    {
        $this->currency = '492'; //SAR
        // $this->currency = '520'; //USD
        if ($settings) {
            $this->loginId = Crypt::decryptString($settings['login_id']);
            $this->companyCode = Crypt::decryptString($settings['company_code']);
            $this->password = md5(Crypt::decryptString($settings['password']));
        } else {
            throw new Exception('DOTWconnect supplier Default settings is required');
        }
    }

    public function getBaseUrl()
    {
        return $this->base_url[$this->mode] . $this->api_version;
    }

    // ============================================================ Core Curl Request ===================================

    public function runRequest($params)
    {
        // return $params;
        $client = new Client(['verify' => false]);
        $response = $client->post($this->getBaseUrl(), [
            'headers' => [
                'Connection' => 'close',
                'Compression' => 'Gzip',
                'Content-Type' => 'text/xml',
                'Content-Encoding' => 'gzip',
            ],
            'body' => '<customer>
            <username>' . $this->loginId . '</username>
            <password>' . $this->password . '</password>
            <id>' . $this->companyCode . '</id>
                <source>1</source>
                <product>hotel</product>
                ' . $params . '</customer>',
        ]);
        return $response->getBody()->getContents();
    }

    private function save_to_file($fileName, $requestData, $responseData)
    {
        //wrire request
        $reqFileName = $fileName . '_request.xml';
        $fp = fopen($reqFileName, 'w');
        fwrite($fp, $requestData);
        fclose($fp);
        //write response
        $fileName = $fileName . '_response.xml';
        $fp = fopen($fileName, 'w');
        fwrite($fp, $responseData);
        fclose($fp);
    }
    // =========================================================== Live Search Request ====================================

    public function hotelSearch($params)
    {
        $rooms = $params['Rooms'];
        $rooms_req = $this->prepareRooms($rooms);
        $requestData =
            '<request command="searchhotels">
                <bookingDetails>
                    <fromDate>' . $params['Checkin'] . '</fromDate>
                    <toDate>' . $params['Checkout'] . '</toDate>
                    <currency>' . $this->currency . '</currency>
                    <rooms no="' . count($rooms) . '">
                        ' . $rooms_req . '
                    </rooms>
                </bookingDetails>
                <return>
                    <filters>
                        <city>' . $params['cityCode'] . '</city>
                        <nearbyCities>true</nearbyCities>
                    </filters>
                </return>
             </request>';
        $xml_res = $this->runRequest($requestData);
        $file_name = 'hotels_search';
        $this->save_to_file($file_name, $requestData, $xml_res);
        return $xml_res;
    }

    // public function hotelSearchCurlHandle($params)
    // {
    //     $rooms = $params['Rooms'];
    //     $rooms_req = $this->prepareRooms($rooms);
    //     $requestData =
    //         '<request command="searchhotels">
    //         <bookingDetails>
    //             <fromDate>' . $params['Checkin'] . '</fromDate>
    //             <toDate>' . $params['Checkout'] . '</toDate>
    //             <currency>' . $this->currency . '</currency>
    //             <rooms no="' . count($rooms) . '">
    //                 ' . $rooms_req . '
    //             </rooms>
    //         </bookingDetails>
    //         <return>
    //             <filters>
    //                 <city>' . $params['cityCode'] . '</city>
    //                 <nearbyCities>true</nearbyCities>
    //             </filters>
    //         </return>
    //      </request>';

    //     $url = $this->getBaseUrl();

    //     $data = '<customer>
    // <username>' . $this->loginId . '</username>
    // <password>' . $this->password . '</password>
    // <id>' . $this->companyCode . '</id>
    //     <source>1</source>
    //     <product>hotel</product>
    //     ' . $requestData . '</customer>';

    //     // Create a new cURL handle
    //     $ch = curl_init();

    //     // Set cURL options
    //     curl_setopt_array($ch, [
    //         CURLOPT_URL => $url,
    //         CURLOPT_RETURNTRANSFER => true,
    //         CURLOPT_ENCODING => '',
    //         CURLOPT_MAXREDIRS => 10,
    //         CURLOPT_TIMEOUT => 0,
    //         CURLOPT_FOLLOWLOCATION => true,
    //         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    //         CURLOPT_CUSTOMREQUEST => 'POST',
    //         CURLOPT_POSTFIELDS => $data,
    //         CURLOPT_HTTPHEADER => [
    //             'Connection: close',
    //             'Compression: Gzip',
    //             'Content-Type: text/xml',
    //             'Content-Encoding: gzip',
    //         ],
    //         CURLOPT_SSL_VERIFYPEER => false,
    //     ]);

    //     return $ch; // Return the cURL handle
    // }

    //NODEJS FN
    public function hotelSearchCurlHandle($params)
    {
        $rooms = $params['Rooms'];
        $rooms_req = $this->prepareRooms($rooms);

        // Build the bookingDetails section
        $bookingDetails = "
            <bookingDetails>
                <fromDate>{$params['Checkin']}</fromDate>
                <toDate>{$params['Checkout']}</toDate>
                <currency>{$this->currency}</currency>
                <rooms no='" . count($rooms) . "'>{$rooms_req}</rooms>
            </bookingDetails>
        ";

        // Build the return section
        $returnSection = "
            <return>
                <filters>
                    <city>{$params['cityCode']}</city>
                    <nearbyCities>true</nearbyCities>
                </filters>
            </return>
        ";

        // Build the full XML request
        $requestData = "
            <request command='searchhotels'>
                {$bookingDetails}
                {$returnSection}
            </request>
        ";

        // Build the data section including customer information and the request data
        $data = "
            <customer>
                <username>{$this->loginId}</username>
                <password>{$this->password}</password>
                <id>{$this->companyCode}</id>
                <source>1</source>
                <product>hotel</product>
                {$requestData}
            </customer>
        ";

        // Get the API URL
        $url = $this->getBaseUrl();
        $user_name = $this->loginId;
        $password = $this->password;
        $id = $this->companyCode;
        $compactXml = str_replace(["\n", "\r", "\t", "  "], '', $data);
        return [
            'url' => $url,
            'headers' => [
                'Connection' => 'close',
                'Compression' => 'Gzip',
                'Content-Type' => 'text/xml',
                'Content-Encoding' => 'gzip'
            ],
            'auth' => [
                'username' => $user_name,
                'password' => $password,
                'id' => $id
            ],
            'data' => $compactXml
        ];
    }

    public function hotelSearchByName($params)
    {
        $rooms = $params['Rooms'];
        $rooms_req = $this->prepareRooms($rooms);
        $requestData =
            '<request command="searchhotels">
                <bookingDetails>
                    <fromDate>' . $params['Checkin'] . '</fromDate>
                    <toDate>' . $params['Checkout'] . '</toDate>
                    <currency>' . $this->currency . '</currency>
                    <rooms no="' . count($rooms) . '">
                        ' . $rooms_req . '
                    </rooms>
                </bookingDetails>
                <return>
                    <filters xmlns:a="http://us.dotwconnect.com/xsd/atomicCondition" xmlns:c="http://us.dotwconnect.com/xsd/complexCondition">
                        <city>' . $params['Id'] . '</city>
                        <c:condition>
                            <a:condition>
                                <fieldName>hotelName</fieldName>
                                <fieldTest>like</fieldTest>
                                <fieldValues>
                                    <fieldValue>' . $params['HotelName'] . '</fieldValue>
                                </fieldValues>
                            </a:condition>
                        </c:condition>
                    </filters>
                </return>
             </request>';
        $xml_res = $this->runRequest($requestData);
        return $xml_res;
    }
    // =========================================================== Get Rooms Request =====================================
    public function getHotelRooms($params)
    {
        $rooms = $params['Rooms'];
        $rooms_req = $this->prepareRooms($rooms);
        $requestData =
            '<request command="getrooms">
                <bookingDetails>
                    <fromDate>' . $params['Checkin'] . '</fromDate>
                    <toDate>' . $params['Checkout'] . '</toDate>
                    <currency>' . $this->currency . '</currency>
                    <rooms no="' . count($rooms) . '">
                        ' . $rooms_req . '
                    </rooms>
                    <productId>' . $params['Id'] . '</productId>
                </bookingDetails>
             </request>';
        $xml_res = $this->runRequest($requestData);
        $file_name = 'available_rooms';
        $this->save_to_file($file_name, $requestData, $xml_res);
        return $xml_res;
    }

    public function selectedRoomsRequest($params)
    {
        $rooms = $params['Rooms'];
        $selectedRooms = $params['SelectedRooms'];
        $rooms_req = $this->prepareRooms($rooms, $selectedRooms);

        $requestData =
            '<request command="getrooms">
                <bookingDetails>
                    <fromDate>' . $params['Checkin'] . '</fromDate>
                    <toDate>' . $params['Checkout'] . '</toDate>
                    <currency>' . $this->currency . '</currency>
                    <rooms no="' . count($rooms) . '">
                        ' . $rooms_req . '
                    </rooms>
                    <productId>' . $params['Id'] . '</productId>
                </bookingDetails>
             </request>';
        $xml_res = $this->runRequest($requestData);
        $file_name = 'room_pricing';
        $this->save_to_file($file_name, $requestData, $xml_res);
        return $xml_res;
    }

    //============================================================ Save Booking Request ====================================
    public function saveBooking($params)
    {
        $rooms = $params['Rooms'];
        $selectedRooms = $params['SelectedRooms'];
        $guestData = $params['guestData'];
        $rooms_req = $this->prepareRooms($rooms, $selectedRooms, $guestData);
        $requestData =
            '<request command="savebooking">
                <bookingDetails>
                    <fromDate>' . $params['Checkin'] . '</fromDate>
                    <toDate>' . $params['Checkout'] . '</toDate>
                    <currency>' . $this->currency . '</currency>
                    <productId>' . $params['Id'] . '</productId>
                    <rooms no="' . count($rooms) . '">
                        ' . $rooms_req . '
                    </rooms>
                    <productId>' . $params['Id'] . '</productId>
                </bookingDetails>
             </request>';
        $xml_res = $this->runRequest($requestData);
        return $xml_res;
    }
    //============================================================ Confirm Booking Request ===================================
    public function confirmBooking($params)
    {

        //     <request command="confirmbooking">
        //     <bookingDetails>
        //         <fromDate>2023-01-25</fromDate>
        //         <toDate>2023-10-28</toDate>
        //         <currency>520</currency>
        //         <productId>123054</productId>
        //         <rooms no="2">
        //             <room runno="0">
        //                 <roomTypeCode>32350855</roomTypeCode>
        //                 <selectedRateBasis>0</selectedRateBasis>
        //                 <allocationDetails>1671970852000001B1000B0</allocationDetails>
        //                 <adultsCode>2</adultsCode>
        //                 <actualAdults>2</actualAdults>
        //                 <children no="0"></children>
        //                 <actualChildren no="0"></actualChildren>
        //                 <passengerNationality>81</passengerNationality>
        //                 <passengerCountryOfResidence>81</passengerCountryOfResidence>
        //                 <selectedExtraMeals></selectedExtraMeals>
        //                 <passengersDetails>
        //                     <passenger leading="yes">
        //                         <salutation>147</salutation>
        //                         <firstName>test</firstName>
        //                         <lastName>one</lastName>
        //                     </passenger>
        //                 </passengersDetails>
        //            </room>
        //             <room runno="1">
        //                 <roomTypeCode>32350855</roomTypeCode>
        //                 <selectedRateBasis>0</selectedRateBasis>
        //                 <allocationDetails>1671970852000001B1000B8</allocationDetails>
        //                 <adultsCode>2</adultsCode>
        //                 <actualAdults>2</actualAdults>
        //                 <children no="1">
        //                     <child runno="0">6</child>
        //                 </children>
        //                 <actualChildren no="1">
        //                     <actualChild runno="0">6</actualChild>
        //                 </actualChildren>

        //                 <passengerNationality>81</passengerNationality>
        //                 <passengerCountryOfResidence>81</passengerCountryOfResidence>
        //                 <selectedExtraMeals></selectedExtraMeals>
        //                 <passengersDetails>
        //                     <passenger leading="yes">
        //                         <salutation>147</salutation>
        //                         <firstName>test</firstName>
        //                         <lastName>two</lastName>
        //                     </passenger>
        //                 </passengersDetails>
        //             </room>
        //         </rooms>
        //     </bookingDetails>
        // </request>
    }
    //============================================================ Preparing Request =======================================

    public function prepareChilds($room)
    {
        $childs = $room['children'];
        $child_req = '';
        if ($childs > 0) {
            $childs_ages = $room['children_ages'];
            foreach ($childs_ages as $key => $age) {
                $child_req .= '<child runno="' . $key . '">' . $age . '</child>';
            }
        }
        return $child_req;
    }

    public function prepareRooms($rooms, $roomSelected = null, $guestData = null)
    {
        $rooms_req = '';
        foreach ($rooms as $key => $room) {
            $rooms_req .= '<room runno="' . $key . '">
            <adultsCode>' . $room['adults'] . '</adultsCode>
            <children no="' . $room['children'] . '">' . $this->prepareChilds($room) . ' </children>
            <rateBasis>1</rateBasis>
            <passengerNationality>81</passengerNationality>
            <passengerCountryOfResidence>81</passengerCountryOfResidence>' . $this->getRoomTypeSelected($roomSelected, $key) .
                '</room>';
        }
        return $rooms_req;
    }

    private function getRoomTypeSelected($selectedRooms, $key)
    {
        if ($selectedRooms) {
            return '<roomTypeSelected>
                         <code>' . $selectedRooms[$key]['RoomTypeCode'] . '</code>
                         <selectedRateBasis>0</selectedRateBasis>
                         <allocationDetails>' . $selectedRooms[$key]['allocationDetails'] . '</allocationDetails>
                    </roomTypeSelected>';
        }
    }

    private function getGuestData($guestData)
    {
        if ($guestData) {
            return '<passengersDetails>
                        <passenger leading="' . $guestData['leading'] . '">
                            <salutation>' . $guestData['salutation'] . '</salutation>
                            <firstName>' . $guestData['first_name'] . '</firstName>
                            <lastName>' . $guestData['last_name'] . '</lastName>
                        </passenger>
                </passengersDetails>';
        }
    }
}
