const express = require('express');
const axios = require('axios');
const bodyParser = require('body-parser');

const app = express();
app.use(bodyParser.json());

app.post('/make-axios-request', async (req, res) => {
    try {
        const { req_handles } = req.body;
        const responses = {};

        const requestPromises = Object.keys(req_handles).map(async (supplierKey) => {
            const { url, headers, auth, data } = req_handles[supplierKey];

            try {
                console.log(url);
                const response = await axios.post(url, data, {
                    headers,
                    auth
                });

                responses[supplierKey] = response.data;
            } catch (error) {
                responses[supplierKey] = { error: error.message };
            }
        });

        await Promise.all(requestPromises);

        res.json(responses);
    } catch (error) {
        // Handle errors and send an error response
        res.status(500).json({ error: error.message });
    }
});

// Start the Express server
const port = 3777; // You can adjust the port as needed

app.listen(port, () => {
    console.log(`Express server is running on port ${port}`);
});
