<?php

use Illuminate\Support\Facades\Route;
use Modules\Hotels\Http\Controllers\HotelsController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware(['agent_auth'])->prefix('modules/hotels')->group(function () {
    Route::get('/auto_complete/{q}', [HotelsController::class, 'auto_complete']);
    Route::get('/search', [HotelsController::class, 'search']);
    Route::get('/available_rooms', [HotelsController::class, 'available_rooms']);
    Route::get('/local_hotel_details/{hid}', [HotelsController::class, 'local_hotel_details/{hid}']);
    Route::get('/pricing', [HotelsController::class, 'pricing']);
    Route::post('/booking', [HotelsController::class, 'booking']);
    Route::post('/pay_from_balance/{merchantReference}', [HotelsController::class, 'pay_from_balance']);
    Route::get('/booking_details/{merchantReference}', [HotelsController::class, 'booking_details']);
    Route::get('/payment_details/{merchantReference}', [HotelsController::class, 'payment_details']);
    Route::get('/pre_payment/{merchantReference}', [HotelsController::class, 'pre_payment']);
    Route::post('/invoice/{merchantReference}', [HotelsController::class, 'invoice']);

    Route::get('/country_list', [HotelsController::class, 'country_list']);
    Route::get('/nationality_list', [HotelsController::class, 'nationality_list']);
});
