<?php

namespace Modules\Payments\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Payment extends Model
{
    const STATUS_PAID = 'paid';
    const STATUS_UNPAID = 'unpaid';
    const STATUS_PENDING = 'pending';
    use HasFactory;
    protected $table = "payment_transactions";
    protected $fillable = [
        'module',
        'supplier_name',
        'supplier_ref',
        'merchant_ref',
        'user_id',
        'currency',
        'net_amount',
        'sale_amount',
        'payment_option',
        'date',
        'token_name',
        'status',
        'status_message',
        'response'
    ];
    protected $casts = [
        'response' => 'json'
    ];
}
