<?php

namespace Modules\StaticData\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Astrotomic\Translatable\Translatable;

class Airport extends Model
{
    use HasFactory, Translatable;

    protected $fillable = [];
    protected $table = 'airports';

    public $translatedAttributes = [
        'name'
    ];

    public function city()
    {
        return $this->belongsTo(City::class);
    }
}
