<?php

namespace Modules\StaticData\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
// use Astrotomic\Translatable\Contracts\Translatable as TranslatableContract;
use Astrotomic\Translatable\Translatable;

class Country extends Model
{
    use HasFactory, Translatable;
    public $timestamps = false;
    protected $fillable = [
        'iso3',
        'numeric_code',
        'iso2',
        'phonecode',
        'capital',
        'currency',
        'currency_name',
        'currency_symbol',
        'tld',
        'native',
        'region',
        'subregion',
        'timezones',
        'lat',
        'lng',
        'emoji',
        'emojiU',
        'flag',
        'wikiDataId',
    ];
    protected $table = 'countries';
    public $translatedAttributes = [
        'name',
        'description'
    ];

    public function cities()
    {
        return $this->hasMany(City::class);
    }

    public function Nationality()
    {
        return $this->belongsTo(Nationality::class, 'id', 'country_id');
    }
}
