<?php

namespace Modules\StaticData\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SupplierCity extends Model
{
    use HasFactory;

    protected $fillable = [
        'supplier_id',
        'city_id',
        'code',
    ];

    protected $table = 'supplier_city';

    public static function getCityId($supplier_id, $supplier_code)
    {
        $city = self::where('supplier_id', $supplier_id)
            ->where('code', $supplier_code)
            ->first();

        if ($city) {
            return $city->city_id;
        }
        return null;
    }
    public function City()
    {
        return $this->belongsTo(City::class);
    }
}
