{{-- Extends layout --}}
@extends('admin.layout.default')
{{-- Content --}}
@section('content')
    <div class="container-fluid">
        <div class="row page-titles mx-0 mb-3">
            <div class="col-sm-6 p-0">
                <div class="welcome-text">
                    <h4>{{ __('Countries') }}</h4>
                    <span>{{ __('All countries list') }}</span>
                </div>
            </div>
            <div class="col-sm-6 p-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('static_data.countries.index') }}">{{ __('Countries') }}</a>
                    </li>
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">{{ __('All Countries') }}</a></li>
                </ol>
            </div>
        </div>

        @php
            $collapsed = 'collapsed';
            $show = '';
        @endphp

        {{-- @if (!empty(request()->name) || !empty(request()->email) || !empty(request()->role))
            @php
                $collapsed = '';
                $show = 'show';
            @endphp
        @endif --}}

        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card accordion accordion-rounded-stylish accordion-bordered" id="search-sec-outer">
                    <div class="accordion-header rounded-lg {{ $collapsed }}" data-bs-toggle="collapse"
                        data-bs-target="#rounded-search-sec">
                        <span class="accordion-header-icon"></span>
                        <h4 class="accordion-header-text m-0">{{ __('Filter') }}</h4>
                        <span class="accordion-header-indicator"></span>
                    </div>
                    <div class="card-body collapse accordion__body {{ $show }}" id="rounded-search-sec"
                        data-bs-parent="#search-sec-outer">
                        {{ Form::model(request()->all(), ['route' => ['static_data.countries.index'], 'method' => 'get']) }}
                        <input type="hidden" name="todo" value="Filter">
                        <div class="row">
                            <div class="form-group col-sm-6 col-md-3 col-lg-4 col-xl-3">
                                {{ Form::text('name_ar', null, ['class' => 'form-control', 'placeholder' => __('Arabic Name')]) }}
                            </div>

                            <div class="form-group col-sm-6 col-md-3 col-lg-4 col-xl-3">
                                {{ Form::text('name_en', null, ['class' => 'form-control', 'placeholder' => __('English Name')]) }}
                            </div>

                            <div class="form-group col-sm-6 col-md-3 col-lg-4 col-xl-3">
                                {{ Form::text('code', null, ['class' => 'form-control', 'placeholder' => __('Code')]) }}
                            </div>

                            <div class=" col-sm-6 col-md-3 col-lg-4 col-xl-3 text-sm-end">
                                <input type="submit" name="search" value="{{ __('Search') }}"
                                    class="btn btn-primary me-2"> <a href="{{ route('static_data.countries.index') }}"
                                    class="btn btn-danger">{{ __('Reset') }}</a>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>

        <!-- row -->
        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('Countries') }}</h4>
                        @can('Modules>StaticData>Http>Controllers>StaticDataController>create')
                            <a href="{{ route('static_data.countries.create') }}"
                                class="btn btn-primary">{{ __('Add Country') }}</a>
                        @endcan
                    </div>
                    <div class="pe-4 ps-4 pt-2 pb-2">
                        <div class="table-responsive">
                            <table class="table table-responsive-lg mb-0">
                                <thead>
                                    <tr>
                                        <th> <strong> {{ __('id.') }} </strong> </th>
                                        <th> <strong> {!! DzHelper::dzSortable('name_ar', __('Name Ar')) !!} </strong> </th>
                                        <th> <strong> {!! DzHelper::dzSortable('name_en', __('Name En')) !!} </strong> </th>
                                        <th> <strong> {!! DzHelper::dzSortable('code', __('Code')) !!} </strong> </th>
                                        @canany([
                                            'Modules>StaticData>Http>Controllers>StaticDataController > edit',
                                            'Modules>StaticData>Http>Controllers>StaticDataController > destroy',
                                            ])
                                            <th class="text-center"> <strong> {{ __('Actions') }} </strong> </th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $i = $countries->firstItem();
                                    @endphp
                                    @forelse ($countries as $country)
                                        <tr>
                                            <td> {{ $i++ }} </td>

                                            <td> {{ $country->name_ar }} </td>
                                            <td> {{ $country->name_en }} </td>
                                            <td> {{ $country->code }} </td>

                                            <td class="text-center ">
                                                @can('Modules>StaticData>Http>Controllers>StaticDataController > edit')
                                                    <a href="{{ route('static_data.countries.edit', $country->id) }}"
                                                        class="btn btn-primary shadow btn-xs sharp me-1"><i
                                                            class="fas fa-pencil-alt"></i></a>
                                                @endcan
                                                @can('Modules>StaticData>Http>Controllers>StaticDataController > destroy')
                                                    <a href="{{ route('static_data.countries.delete', $country->id) }}"
                                                        class="btn btn-danger shadow btn-xs sharp me-1"><i
                                                            class="fa fa-trash"></i></a>
                                                @endcan
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center">{{ __('No countries') }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer">
                        {{ $countries->appends(Request::input())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
