<?php

namespace App\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use App\Services\CustomEncrypter;

class CustomEncryptCast implements CastsAttributes
{
    public function get($model, $key, $value, $attributes)
    {
        $encrypter = new CustomEncrypter(); // Create an instance of CustomEncrypter
        // Decrypt the attribute using your custom decrypt function
        return $encrypter->customDecrypt($value);
    }

    public function set($model, $key, $value, $attributes)
    {
        $encrypter = new CustomEncrypter(); // Create an instance of CustomEncrypter
        // Encrypt the attribute using your custom encrypt function
        return $encrypter->customCrypt($value);
    }
}
