<?php

use App\Models\Logs;
use App\Models\User;
use App\Models\WowSession;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

//response
function json_response($data, $code=200)
{
    return response()->json($data, $code);
}

function json_response_pagination($data, int $code = 200, bool $status = true, string $message = 'success')
{
    $pagination = [
        'current_page' => $data->currentPage(),
        'total_pages' => $data->lastPage(),
        'total_results' => $data->total(),
        'per_page' => $data->perPage(),
        'from' => $data->firstItem(),
        'to' => $data->lastItem()
    ];
    return response()->json([
        'status' => $status,
        'message' => $message,
        'data' => $data->items(),
        'pagination' => $pagination
    ], $code);
}





