<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Markup;
use Illuminate\Http\Request;
use App\Models\Module;
use App\Models\Role;
use App\Models\Supplier;
use App\Models\User;
use Illuminate\Support\Facades\View;
use Illuminate\Validation\Rule;

class MarkupController extends Controller
{
    /**
     * Display a listing of the users.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $page_title = __('web.agents_markup');
        $resultQuery = User::query();

        if ($request->filled('name')) {
            $resultQuery->where('name', 'like', "%{$request->input('name')}%");
        }

        if ($request->filled('email')) {
            $resultQuery->where('email', 'like', "%{$request->input('email')}%");
        }

        $sortBy = $request->get('sort') ? $request->get('sort') : 'created_at';
        $direction = $request->get('direction') ? $request->get('direction') : 'desc';
        $resultQuery->orderBy($sortBy, $direction);

        $users = $resultQuery->agents()->paginate(config('Reading.nodes_per_page'));

        return view('admin.markup.index', compact('users', 'page_title'));
    }

    public function prepare_settings($request)
    {
        $settings = $request->settings;
        if (count($settings) > 0) {
            foreach ($settings as $item) {
                list($key, $value) = $item;
                $outputArray[$key] = $value;
            }
            return $outputArray;
        } else {
            return [];
        }
    }

    /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $page_title = __('Edit Agent Markup');
        $agent = User::findorFail($id);
        $agent_markup = $agent->markup();
        if (!$agent_markup) {
            $agent_markup['markup_type'] = 'fixed';
            $agent_markup['fixed_amount'] = 0;
            $agent_markup['percentage'] = 0;
            $agent_markup['cut_off'] = false;
            $agent_markup['over_write'] = false;
        }
        $modules = Module::with('suppliers')->get();
        $userRoles = User::get_roles($id);
        $userModules = User::get_modules($id);
        $userSuppliers = User::get_suppliers($id);
        return view('admin.markup.edit', compact('agent', 'agent_markup', 'modules', 'userSuppliers', 'userModules', 'page_title'));
    }

    /**
     * Update the specified user in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // return $request->all();
        //store agent main markup details 
        $agent = $request->agent;
        Markup::updateOrCreate([
            'agent_id' => $id,
            'type' => Markup::Type_Agent
        ], [
            'agent_id' => $id,
            'type' => Markup::Type_Agent,
            'data' => [
                'over_write' => isset($agent['over_write']) ?? false,
                'cut_off' => isset($agent['cut_off']) ?? false,
                'markup_type' => $agent['markup_type'],
                'fixed_amount' => $agent['fixed_amount'],
                'percentage' => $agent['percentage']
            ]
        ]);

        //store Modules main markup 
        $modules = $request->agent['modules'];
        foreach ($modules as $module_id => $module) {
            Markup::updateOrCreate([
                'agent_id' => $id,
                'module_id' => $module_id,
                'type' => Markup::Type_Module
            ], [
                'agent_id' => $id,
                'module_id' => $module_id,
                'type' => Markup::Type_Module,
                'data' => [
                    'over_write' => isset($module['over_write']) ?? false,
                    'cut_off' => isset($module['cut_off']) ?? false,
                    'markup_type' => $module['markup_type'],
                    'fixed_amount' => $module['fixed_amount'],
                    'percentage' => $module['percentage'],
                    'booking_from' => $module['booking_from'],
                    'booking_to' => $module['booking_to'],
                    'reservation_from' => $module['reservation_from'],
                    'reservation_to' => $module['reservation_to']
                ]
            ]);

            foreach ($module['suppliers'] as $supplier_id => $supplier) {
                Markup::updateOrCreate([
                    'agent_id' => $id,
                    'module_id' => $module_id,
                    'supplier_id' => $supplier_id,
                    'type' => Markup::Type_Supplier
                ], [
                    'agent_id' => $id,
                    'module_id' => $module_id,
                    'supplier_id' => $supplier_id,
                    'type' => Markup::Type_Supplier,
                    'data' => [
                        'over_write' => isset($supplier['over_write']) ?? false,
                        'cut_off' => isset($supplier['cut_off']) ?? false,
                        'markup_type' => $supplier['markup_type'],
                        'fixed_amount' => $supplier['fixed_amount'],
                        'percentage' => $supplier['percentage'],
                        'booking_from' => $supplier['booking_from'],
                        'booking_to' => $supplier['booking_to'],
                        'reservation_from' => $supplier['reservation_from'],
                        'reservation_to' => $supplier['reservation_to']
                    ]
                ]);
            }
        }
        // if ($supplier->save()) {
        return redirect()->route('admin.markup.edit', ['id' => $id])->with('success', __('Updated successfully'));
        // } else {
        //     return redirect()->back()->with('error', __('There are some problem in form submition.'));
        // }
    }

    /**
     * Remove the specified user from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $supplier = Supplier::findorFail($id);
        if ($supplier->delete()) {
            return redirect()->back()->with('success', __('Deleted successfully'));
        } else {
            return redirect()->back()->with('error', __('There are some problem.'));
        }
    }
}
