<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    //login
    public function login(Request $request)
    {
        try {
            if (!Auth::attempt($request->only('email', 'password'))) {
                return response()->json([
                    'status' => false,
                    'message' => 'Invalid login details'
                ], 401);
            }

            $user = User::with(['balance'])->where('email', $request['email'])->firstOrFail();
            $user->modules = $user->scopemodules();
            $token = $user->createToken('auth_token')->plainTextToken;

            return response()->json([
                'data' => [
                    'token' => $token,
                    'user' => $user,
                    // 'modules' => $user->modules
                ],
                'status' => true,
                'message' => "Success",
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    //logout
    public function logout(Request $request)
    {
        // Revoke the token that was used to authenticate the current request
        $request->user()->currentAccessToken()->delete();
        //$request->user->tokens()->delete(); // use this to revoke all tokens (logout from all devices)
        return response()->json(null, 200);
    }

    /*
       * Get authenticated user details
      */
    public function getAuthenticatedUser(Request $request)
    {
        $user = $request->agent;
        $user->modules =  $user->scopeModules();
        $user->credit_amount =  $user->balance->credit_amount;
        $user->currency =  $user->balance->currency;
        $user->credit_allowed_amount =  $user->balance->credit_allowed_amount;
        $user->settings =  [];
        return response()->json([
            'data' => $user,
            'message' => 'user info loaded ',
            'status' => 'success',
        ], 200);
    }

    public function get_user_modules_with_suppliers(Request $request)
    {
        try {
            $agent = $request->agent;
            $modules = $agent->scopeModulesAndSuppliers();
            return response()->json([
                'status' => true,
                'data' => [
                    'modules' => $modules
                ]
            ]);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'message' => $e->getMessage(),
                'data' => []
            ]);
        }
    }
}
