<?php

namespace App\Http\Middleware;

use App\Models\User;
use Closure;
use Illuminate\Http\Request;

class AgentAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $token = $request->bearerToken();
        $headers = $request->header();
        $lang = $headers['x-language-code'][0] ?? null;
        app()->setLocale($lang);
        $user = $this->isValidAgentToken($token);
        if (!$token || !$user) {
            return response()->json(['error' => 'Authentication error'], 401);
        }
        $request->merge(['agent' => $user]);
        return $next($request);
    }

    private function isValidAgentToken($token)
    {
        $user = User::where('agent_token', $token)->where('status', 1)->first();
        if ($user) {
            return $user;
        }
    }
}
