<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserSupplier extends Model
{
    use HasFactory;
    protected $table = "user_supplier";
    protected $fillable = [
        'user_id',
        'supplier_id',
        'module_id',
        'supplier_settings'
    ];
    protected $casts = [
        'supplier_settings' => 'array'
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function module()
    {
        return $this->belongsTo(Module::class);
    }
}
