<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>{{ config('dz.name') }}</title>
    <meta name="description" content="@yield('page_description', $page_description ?? '')"/>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('storage/configuration-images/'.config('Site.favicon')) }}">
    
    @php
        $action = DzHelper::controller().'_'.DzHelper::action();
    @endphp
    @if(isset($action) && !empty(config('dz.public.pagelevel.css.'.$action))) 
        @foreach(config('dz.public.pagelevel.css.'.$action) as $style)
            <link href="{{ asset($style) }}" rel="stylesheet" type="text/css"/>
        @endforeach
    @endif  

    {{-- Global Theme Styles (used by all pages) --}}
    @if(!empty(config('dz.public.global.css'))) 
        @foreach(config('dz.public.global.css') as $style)
            <link href="{{ asset($style) }}" rel="stylesheet" type="text/css"/>
        @endforeach
    @endif
    
</head>

<body class="Vh-100 {{ (preg_match('(login|register|forgot-password|two-factor-challenge)', URL::current()) == 1) ? 'authPages' : '' }}">
    <div class="authincation h-100">
        <div class="container h-100">
            <div class="row kkk justify-content-center h-100 align-items-center">
			@yield('content')
            </div>
        </div>
    </div>
    
    <!--**********************************
        Scripts
    ***********************************-->

    @stack('inline-scripts')
    
    @if(!empty(config('dz.public.global.js.top')))
        @foreach(config('dz.public.global.js.top') as $script)
                <script src="{{ asset($script) }}" type="text/javascript"></script>
        @endforeach
    @endif
    @if(!empty(config('dz.public.pagelevel.js.'.$action)))
        @foreach(config('dz.public.pagelevel.js.'.$action) as $script)
                <script src="{{ asset($script) }}" type="text/javascript"></script>
        @endforeach
    @endif
    @if(!empty(config('dz.public.global.js.bottom')))
        @foreach(config('dz.public.global.js.bottom') as $script)
                <script src="{{ asset($script) }}" type="text/javascript"></script>
        @endforeach
    @endif

    @yield('scripts')

</body>

</html>