<div class="basic-form">
    <div class="row">
        <div class="form-group col-md-2">
            <div class="form-group">
                <label for="markup_type">{{ __('Markup Type') }}</label>
                <select name="agent[modules][{{ $module->id }}][markup_type]" id="markup_type_{{ $module->id }}"
                    class="form-control" onchange="handleMarkupTypeChange({{ $module->id }})">
                    <option value="fixed" {{ isset($markup['type']) && $markup['type'] == 'fixed' ? 'selected' : '' }}>
                        {{ __('Fixed') }}</option>
                    <option value="percentage"
                        {{ isset($markup['type']) && $markup['type'] == 'percentage' ? 'selected' : '' }}>
                        {{ __('Percentage') }}</option>
                    <option value="both" {{ isset($markup['type']) && $markup['type'] == 'both' ? 'selected' : '' }}>
                        {{ __('Both') }}</option>
                </select>
            </div>
        </div>

        <div class="form-group col-md-5">
            <div class="form-group" id="fixed_amount_{{ $module->id }}"
                style="{{ !isset($markup['fixed_amount']) ? 'display: none;' : '' }}">
                <label for="fixed_amount">{{ __('Fixed Markup') }}</label>
                <input type="number" name="agent[modules][{{ $module->id }}][fixed_amount]" id="fixed_amount{}"
                    class="form-control" value="{{ isset($markup['fixed_amount']) ? $markup['fixed_amount'] : '' }}">
                @error('fixed_amount')
                    <p class="text-danger">{{ $message }}</p>
                @enderror
            </div>
        </div>

        <div class="form-group col-md-5">
            <div class="form-group" id="percentage_amount_{{ $module->id }}"
                style="{{ !isset($markup['percentage']) ? 'display: none;' : '' }}">
                <label for="percentage">{{ __('Percentage Markup') }}</label>
                <input type="number" name="agent[modules][{{ $module->id }}][percentage]" class="form-control"
                    value="{{ isset($markup['percentage']) ? $markup['percentage'] : '' }}">
                @error('percentage')
                    <p class="text-danger">{{ $message }}</p>
                @enderror
            </div>
        </div>
        <div class="form-group col-md-5">
            <label for="booking_from">{{ __('Booking From Date') }}</label>
            <input type="datetime-local" name="agent[modules][{{ $module->id }}][booking_from]"
                id="booking_from{{ $module->id }}" class="form-control"
                value="{{ isset($markup['booking_from']) ? $markup['booking_from'] : '' }}">
        </div>

        <div class="form-group col-md-5">
            <label for="booking_to">{{ __('Booking To Date') }}</label>
            <input type="datetime-local" name="agent[modules][{{ $module->id }}][booking_to]"
                id="booking_to{{ $module->id }}" class="form-control"
                value="{{ isset($markup['booking_to']) ? $markup['booking_to'] : '' }}">
        </div>

        <div class="form-group col-md-5">
            <label for="reservation_from">{{ __('Reservation From Date') }}</label>
            <input type="datetime-local" name="agent[modules][{{ $module->id }}][reservation_from]"
                id="reservation_from{{ $module->id }}" class="form-control"
                value="{{ isset($markup['reservation_from']) ? $markup['reservation_from'] : '' }}">
        </div>

        <div class="form-group col-md-5">
            <label for="reservation_to">{{ __('Reservation To Date') }}</label>
            <input type="datetime-local" name="agent[modules][{{ $module->id }}][reservation_to]"
                id="reservation_to{{ $module->id }}" class="form-control"
                value="{{ isset($markup['reservation_to']) ? $markup['reservation_to'] : '' }}">
        </div>

        <div class="form-group col-md-5">
            <input type="checkbox" name="agent[modules][{{ $module->id }}][cut_off]"
                id="module_cut_off_{{ $module->id }}"
                {{ isset($markup['cut_off']) && $markup['cut_off'] ? 'checked' : '' }}>
            <label for="cut-off">{{ __('Cut-off') }}</label>
            <p class="note">{{ __('Check this to apply cut-off or leave it a commission.') }}</p>
        </div>

        <div class="form-group col-md-6">
            <input type="checkbox" name="agent[modules][{{ $module->id }}][over_write]"
                id="module_cut_off_{{ $module->id }}"
                {{ isset($markup['over_write']) && $markup['over_write'] ? 'checked' : '' }}>
            <label for="over_write">{{ __('overwrite') }}</label>
            <p class="note">{{ __('Check this to apply overwrite over other markups for this agent.') }}
            </p>
        </div>

    </div>
</div>
