{{-- Extends layout --}}
@extends('admin.layout.default')
{{-- Content --}}
@section('content')
    <div class="container-fluid">
        <div class="row page-titles mx-0 mb-3">
            <div class="col-sm-6 p-0">
                <div class="welcome-text">
                    <h4>{{ __('Suppliers') }}</h4>
                    <span>{{ __('All suppliers list') }}</span>
                </div>
            </div>
            <div class="col-sm-6 p-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.suppliers.index') }}">{{ __('Suppliers') }}</a>
                    </li>
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">{{ __('All Suppliers') }}</a></li>
                </ol>
            </div>
        </div>

        @php
            $collapsed = 'collapsed';
            $show = '';
        @endphp

        {{-- @if (!empty(request()->name) || !empty(request()->email) || !empty(request()->role))
            @php
                $collapsed = '';
                $show = 'show';
            @endphp
        @endif --}}

        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card accordion accordion-rounded-stylish accordion-bordered" id="search-sec-outer">
                    <div class="accordion-header rounded-lg {{ $collapsed }}" data-bs-toggle="collapse"
                        data-bs-target="#rounded-search-sec">
                        <span class="accordion-header-icon"></span>
                        <h4 class="accordion-header-text m-0">{{ __('Filter') }}</h4>
                        <span class="accordion-header-indicator"></span>
                    </div>
                    <div class="card-body collapse accordion__body {{ $show }}" id="rounded-search-sec"
                        data-bs-parent="#search-sec-outer">
                        {{ Form::model(request()->all(), ['route' => ['admin.suppliers.index'], 'method' => 'get']) }}
                        <input type="hidden" name="todo" value="Filter">
                        <div class="row">
                            <div class="form-group col-sm-6 col-md-3 col-lg-4 col-xl-3">
                                {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => __('English Name')]) }}
                            </div>

                            <div class="form-group col-sm-6 col-md-3 col-lg-4 col-xl-3">
                                {{ Form::text('module_key', null, ['class' => 'form-control', 'placeholder' => __('Module')]) }}
                            </div>

                            <div class=" col-sm-6 col-md-3 col-lg-4 col-xl-3 text-sm-end">
                                <input type="submit" name="search" value="{{ __('Search') }}"
                                    class="btn btn-primary me-2"> <a href="{{ route('admin.suppliers.index') }}"
                                    class="btn btn-danger">{{ __('Reset') }}</a>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
        </div>

        <!-- row -->
        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('Suppliers') }}</h4>
                        @can('Controllers>SuppliersController>create')
                            <a href="{{ route('admin.suppliers.create') }}"
                                class="btn btn-primary">{{ __('Add Supplier') }}</a>
                        @endcan
                    </div>
                    <div class="pe-4 ps-4 pt-2 pb-2">
                        <div class="table-responsive">
                            <table class="table table-responsive-lg mb-0">
                                <thead>
                                    <tr>
                                        <th> <strong> {{ __('id.') }} </strong> </th>
                                        <th> <strong> {!! DzHelper::dzSortable('name', __('Name')) !!} </strong> </th>
                                        <th> <strong> {!! DzHelper::dzSortable('module_key', __('Module')) !!} </strong> </th>
                                        <th> <strong> {!! DzHelper::dzSortable('status', __('Status')) !!} </strong> </th>
                                        @canany(['Controllers>SuppliersController > edit',
                                            'Controllers>SuppliersController > destroy'])
                                            <th class="text-center"> <strong> {{ __('Actions') }} </strong> </th>
                                        @endcanany
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $i = $suppliers->firstItem();
                                    @endphp
                                    @forelse ($suppliers as $supplier)
                                        <tr>
                                            <td> {{ $i++ }} </td>

                                            <td> {{ $supplier->name }} </td>
                                            <td> {{ $supplier->module_key }} </td>
                                            <td> {{ $supplier->status?__('Active'):__('Disabled') }} </td>

                                            <td class="text-center ">
                                                @can('Controllers>SuppliersController > edit')
                                                    <a href="{{ route('admin.suppliers.edit', $supplier->id) }}"
                                                        class="btn btn-primary shadow btn-xs sharp me-1"><i
                                                            class="fas fa-pencil-alt"></i></a>
                                                @endcan
                                                @can('Controllers>SuppliersController > destroy')
                                                    <a href="{{ route('admin.suppliers.delete', $supplier->id) }}"
                                                        class="btn btn-danger shadow btn-xs sharp me-1"><i
                                                            class="fa fa-trash"></i></a>
                                                @endcan
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center">{{ __('No suppliers') }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer">
                        {{ $suppliers->appends(Request::input())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
