{{-- Extends layout --}}
@extends('admin.layout.default')

{{-- Content --}}
@section('content')
    <div class="container-fluid">
        <div class="row page-titles mx-0 mb-3">
            <div class="col-sm-6 p-0">
                <div class="welcome-text">
                    <h4>{{ __('Users') }}</h4>
                    <span>{{ __('Edit user') }}</span>
                </div>
            </div>
            <div class="col-sm-6 p-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">{{ __('Users') }}</a></li>
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">{{ __('Edit User') }}</a></li>
                </ol>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">{{ __('Edit User') }}</h4>
            </div>
            <form action="{{ route('admin.users.update', $user->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="basic-form">
                        <div class="row align-items-center">
                            <div class="form-group col-sm-4 ">
                                <div class=" text-center">
                                    <div class="custom-img-upload img-parent-box mt-4">

                                        <img src="{{ HelpDesk::user_img($user->profile) }}" class="img-for-onchange"
                                            id="RemoveProfile_{{ $user->id }}" alt="{{ __('User Profile') }}">

                                        <div class="upload-btn">

                                            @if ($user->profile)
                                                <a href="javascript:void(0);"
                                                    rdx-link="{{ route('admin.user.remove_user_image', $user->id) }}"
                                                    class="rdxUpdateAjax btn btn-primary btn-xs me-1"
                                                    rdx-delete-box="RemoveProfile_{{ $user->id }}">{{ __('Remove') }}</a>
                                            @endif

                                            <input type="file"
                                                class="form-file-input form-control ps-2 img-input-onchange" name="user_img"
                                                id="user_img" accept=".png, .jpg, .jpeg" hidden>
                                            <label class="upload-label btn btn-xs btn-primary m-0"
                                                for="user_img">{{ __('Upload') }}</label>
                                        </div>
                                        @error('user_img')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="row">
                                    <div class="form-group col-12">
                                        <label>{{ __('First Name') }}</label>
                                        <input type="text" name="first_name" id="first_name" class="form-control"
                                            value="{{ old('first_name', $user->first_name) }}">
                                        @error('first_name')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-12">
                                        <label>{{ __('Last Name') }}</label>
                                        <input type="text" name="last_name" id="last_name" class="form-control"
                                            value="{{ old('last_name', $user->last_name) }}">
                                        @error('last_name')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                    <div class="form-group col-12">
                                        <label>{{ __('Email') }}</label>
                                        <input type="email" name="email" id="email" class="form-control"
                                            value="{{ old('email', $user->email) }}">
                                        @error('email')
                                            <p class="text-danger">
                                                {{ $message }}
                                            </p>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer pt-0 text-end">
                    <button type="submit" class="btn btn-primary">{{ __('Update') }}</button>
                    <a href="{{ route('admin.users.index') }}" class="btn btn-danger">{{ __('Back') }}</a>
                </div>
            </form>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">{{ __('User Agent Token') }}</h4>
            </div>
            <div class="card-body">
                <div class="input-group mb-3">
                    <input type="text" id="tokenContainer" class="form-control" value="{{ $user->agent_token }}"
                        disabled>
                    <button id="copyTokenBtn" class="btn btn-primary" type="button">
                        <i class="fas fa-copy"></i>
                    </button>
                </div>
                <button id="generateTokenBtn" class="btn btn-sm btn-primary">{{ __('Generate New Token') }}</button>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">{{ __('Update Password') }}</h4>
            </div>
            <form action="{{ route('admin.users.update-password', $user->id) }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="basic-form">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="dz-password">{{ __('Password') }}</label>
                                <div class="input-group">
                                    <input type="password" name="password" id="dz-password" class="form-control"
                                        autocomplete="new-password">
                                    <span class="input-group-text show-pass">
                                        <i class="fa fa-eye-slash"></i>
                                        <i class="fa fa-eye"></i>
                                    </span>
                                </div>
                                @error('password')
                                    <p class="text-danger">
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>
                            <div class="form-group col-md-6">
                                <label for="dz-con-password">{{ __('Confirm Password') }}</label>
                                <div class="input-group">
                                    <input type="password" name="confirm_password" id="dz-con-password"
                                        class="form-control" autocomplete="new-password">
                                    <span class="input-group-text show-con-pass">
                                        <i class="fa fa-eye-slash"></i>
                                        <i class="fa fa-eye"></i>
                                    </span>
                                </div>
                                @error('confirm_password')
                                    <p class="text-danger">
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer text-end">
                    <button type="submit" class="btn btn-primary">{{ __('Update') }}</button>
                    <a href="{{ route('admin.users.index') }}" class="btn btn-danger">{{ __('Back') }}</a>
                </div>
            </form>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">{{ __('Assign Role & Type') }}</h4>
            </div>
            <form action="{{ route('admin.users.update_user_roles', $user->id) }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="basic-form">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="type">{{ __('Type') }}</label>
                                <select name="type" id="type" class="default-select form-control">
                                    <option value="b2b">b2b</option>
                                    <option value="b2c">b2c</option>
                                    <option value="admin">admin</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="roles">{{ __('Roles') }}</label>
                                <select name="roles[]" id="roles" class="default-select form-control"
                                    multiple="true">
                                    @forelse($roles as $role)
                                        <option value="{{ $role->id }}"
                                            {{ in_array($role->id, $userRoles) ? 'selected="selected"' : '' }}>
                                            {{ $role->name }}
                                        </option>
                                    @empty
                                    @endforelse
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer text-end">
                    <button type="submit" class="btn btn-primary">{{ __('Update') }}</button>
                    <a href="{{ route('admin.users.index') }}" class="btn btn-danger">{{ __('Back') }}</a>
                </div>
            </form>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">{{ __('Assign Modules And Suppliers') }}</h4>
            </div>
            <form action="{{ route('admin.users.update_user_modules_and_supplier', $user->id) }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="basic-form">
                        <div class="row">
                            <div class="col-md-12">
                                @foreach ($modules as $module)
                                    <div class="form-group mb-3">
                                        @php
                                            $suppliers = $module->suppliers ?? [];
                                        @endphp
                                        <h3 class="checkbox-container ">
                                            <input type="checkbox" name="modules[{{ $module->id }}]"
                                                style="width:20px;height:20px" value="{{ $module->id }}"
                                                {{ in_array($module->id, $userModules) ? 'checked' : '' }}>
                                            {{ $module->name . ' ' . __('Module') }}
                                        </h3>
                                        <h5 class="mb-2 ms-4">{{ __('Suppliers') }}</h5>
                                        <div class="row">
                                            <div class="col-12 ms-4 row">
                                                @foreach ($suppliers as $supplier)
                                                    <div class="checkbox-container col-2">
                                                        <input type="checkbox"
                                                            name="modules[{{ $module->id }}][suppliers][{{ $supplier->id }}]"
                                                            value="{{ $supplier->id }}"
                                                            {{ in_array($supplier->id, $userSuppliers) ? 'checked' : '' }}>
                                                        {{ $supplier->name }}
                                                        <a href="" style="padding: 4px"
                                                            onclick="toggleSupplierSettings({{ $supplier->id }})">
                                                            <i class="fa fa-cog" aria-hidden="true"
                                                                title="{{ __('Settings') }}"></i>
                                                        </a>
                                                    </div>
                                                    <div class="col-9">
                                                        <div class="form-group col-12 supplier_settings_{{ $supplier->id }}"
                                                            style="display:none">
                                                            <label class="font-weight-bold">{{ __('Settings') }}</label>
                                                            <div class="table-responsive">
                                                                <table id="settingsTable"
                                                                    class="table settingsTable_{{ $supplier->id }}">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>{{ __('Key') }}</th>
                                                                            <th>{{ __('Value') }}</th>
                                                                            <th></th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        @php
                                                                            $settings = $supplier->getUserSupplierSettingsAttribute($user->id);
                                                                            ${'supplier_' . $supplier->id . '_count'} = 0;
                                                                        @endphp
                                                                        @if (count($settings) > 0)
                                                                            @foreach ($settings as $index => $setting)
                                                                                <tr>
                                                                                    <td class="col-4">
                                                                                        <input type="text"
                                                                                            {{-- name="settings[{{ $supplier->id }}][{{ ${'supplier_' . $supplier->id . '_count'} }}][]" --}}
                                                                                            name="modules[{{ $module->id }}][suppliers][{{ $supplier->id }}][settings][{{ ${'supplier_' . $supplier->id . '_count'} }}][]"
                                                                                            class="form-control"
                                                                                            value="{{ $index }}">
                                                                                    </td>
                                                                                    <td>
                                                                                        <input type="text"
                                                                                            {{-- name="settings[{{ $supplier->id }}][{{ ${'supplier_' . $supplier->id . '_count'} }}][]" --}}
                                                                                            name="modules[{{ $module->id }}][suppliers][{{ $supplier->id }}][settings][{{ ${'supplier_' . $supplier->id . '_count'} }}][]"
                                                                                            class="form-control"
                                                                                            value="{{ $setting }}">
                                                                                    </td>
                                                                                    <td>
                                                                                        <button
                                                                                            class="btn btn-danger remove-setting"
                                                                                            type="button">&times;</button>
                                                                                    </td>
                                                                                </tr>
                                                                                @php ${'supplier_' . $supplier->id . '_count'}++; @endphp
                                                                            @endforeach
                                                                        @endif
                                                                    </tbody>
                                                                </table>
                                                            </div>

                                                            <button
                                                                onclick="addSettings({{ $module->id }},{{ $supplier->id }})"
                                                                class="btn btn-xs btn-primary ms-2"
                                                                type="button">{{ __('Add settings') }}</button>

                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>

                                        </div>
                                    </div>
                                    <hr style="font-size: 2px; margin-top: 1rem;">
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                    <a href="{{ route('admin.users.index') }}" class="btn btn-danger">{{ __('Cancel') }}</a>
                </div>
            </form>
        </div>

        <div class="card-footer text-end">
            <button type="submit" class="btn btn-primary">{{ __('Update') }}</button>
            <a href="{{ route('admin.users.index') }}" class="btn btn-danger">{{ __('Back') }}</a>
        </div>
        </form>
    </div>

    </div>
@endsection
@push('inline-scripts')
    <script>
        function toggleSupplierSettings(supplierId) {
            event.preventDefault();
            var settingsDiv = document.querySelector('.supplier_settings_' + supplierId);
            if (settingsDiv) {
                settingsDiv.style.display = (settingsDiv.style.display === 'none' || settingsDiv.style.display === '') ?
                    'block' : 'none';
            }
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#generateTokenBtn').click(function() {
                $.ajax({
                    url: '{{ route('admin.users.update_agent_token', $user->id) }}',
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        if (response.status) {
                            var newToken = response.newToken;
                            // Update the token display with the new token
                            var tokenContainer = $('#tokenContainer');
                            tokenContainer.empty(); // Clear the container
                            tokenContainer.val(newToken);
                        } else {
                            alert('Token generation failed.'.response.error);
                        }
                    },
                    error: function(error) {
                        alert('An error occurred while generating the token.');
                    }
                });
            });
        });
    </script>

    <script>
        function addSettings(moduleId, supplierId) {
            var className = "settingsTable_" + supplierId;
            var tableBody = document.getElementsByClassName(className)[0].getElementsByTagName('tbody')[0];
            var i = tableBody.rows.length
            var newRow = tableBody.insertRow();
            newRow.innerHTML = `
            <td class="col-4"><input type="text" name="modules[${moduleId}][suppliers][${supplierId}][settings][${i}][]"" class="form-control"></td>
            <td class="col-8"><input type="text" name="modules[${moduleId}][suppliers][${supplierId}][settings][${i}][]"" class="form-control"></td>
            <td><button class="btn btn-danger remove-setting" type="button">&times;</button></td>
        `;
        }
    </script>

    <script>
        // Remove the setting row when the "Remove" button is clicked
        document.addEventListener('click', function(event) {
            if (event.target.classList.contains('remove-setting')) {
                var row = event.target.parentNode.parentNode;
                var tableBody = row.parentNode;
                // Check if there is only one row left
                if (tableBody.rows.length > 1) {
                    tableBody.removeChild(row);
                }
            }
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#copyTokenBtn').click(function() {
                // Select the old token text
                var oldTokenText = document.getElementById('tokenContainer');
                var range = document.createRange();
                range.selectNode(oldTokenText);
                window.getSelection().removeAllRanges();
                window.getSelection().addRange(range);

                // Copy the selected text
                try {
                    document.execCommand('copy');
                    window.getSelection().removeAllRanges();
                    alert('Token copied to clipboard');
                } catch (err) {
                    console.error('Unable to copy token: ' + err);
                }
            });
        });
    </script>
@endpush
