<?php

namespace App\Console\Commands;

use App\Mail\LowBalanceNotification;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Modules\Users\Entities\User;

class NotifyLowBalance extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notify:low-balance';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This command sends notifications to user when its has a low balance ';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
 
        public function handle()
        {
            Log::info('Command started: '. $this->signature);
            $threshold = 100000; // Set the threshold value
            $users = User::where('credit_amount', '<', $threshold)->get();
        
            foreach ($users as $user) {
                Mail::to($user->email)->send(new LowBalanceNotification($user));
            }
        }
    
}
