<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Modules\Users\Entities\User as EntitiesUser;
use Illuminate\Support\Facades\Route;
use Artisan;
use Illuminate\Support\Facades\Auth;
use Modules\Users\Http\Controllers\PermissionsController;

class HasPermissionMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */

    public function handle(Request $request, Closure $next)
    {

        return app(Authenticate::class)->handle($request, function ($request) use ($next) {
            $user = $request->user();
            $user_type=$user->type;
            $route_name = $request->route()->action['as'] ?? '';
            //check for super admin
            if ($user->type = "super_admin" && $user->email == env('ADMIN_EMAIL')) {
                $request->attributes->set('parent', $user->id);
                $request->attributes->set('type', 'super_admin');
                return $next($request);
            }
            //check user have permission to this route
            if (empty($route_name) || ($route_name && $user->hasPermissionTo($route_name))) {
                //check companies
                if ($user_type == 'company') {
                    $request->attributes->set('company_id', $user->id);
                    $request->attributes->set('parent', $user->id);
                    $request->attributes->set('type', 'company');
                    return $next($request);
                }
                //check for companies employee
                if ($user_type == 'employee') {
                    $parent = EntitiesUser::where('id', $user->parent_id)->first();
                    $request->attributes->set('parent', $parent->id);
                    $request->attributes->set('type', 'employee');
                    return $next($request);
                }
            } else {
                return response()->json([
                    'status' => false,
                    'message' => "no access to ( " . $route_name . " ) permission",
                ], 200);
            }
        }, 'sanctum');
    }
}
