<?php

use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use Modules\HotelMapping\Http\Controllers\BedsHotelsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

// =====================================================================test apis ==========================

Route::get('/countries', function () {
    $endpoint = "https://restcountries.com/v3.1/all";
    $client = new \GuzzleHttp\Client(['verify' => false]);
    $id = 5;
    $value = "ABC";

    $response = $client->request('GET', $endpoint, ['query' => [
        'key1' => $id,
        'key2' => $value,
    ]]);

    $countries = json_decode($response->getBody());
    // $db_countries = DB::table('wow_countries')->get();
    foreach ($countries as $country) {
        DB::table('wow_countries')->updateOrInsert(
            ['code' => $country->cca2],
            [
                'code' => $country->cca2,
                'name_en' => $country->name->common,
                'name_ar' => $country->translations->ara->common,
                // 'flag' => $country->flag,
                'region' => $country->region,
                'phone_code' => isset($country->idd->root) && isset($country->idd->suffixes[0]) ? $country->idd->root . $country->idd->suffixes[0] : null,
                'iso3_code' => $country->cca3,
                // 'currency' => array_keys($country->currencies[0]),
                'image' => $country->flags->png,
            ]

        );
    }
});

Route::get('/dotw_countries', function () {
    $client = new Client();
    $headers = [
        'Connection' => 'close',
        'Compression' => 'Gzip',
        'Content-Type' => 'text/xml, application/x-www-form-urlencoded',
        'Content-Encoding' => 'gzip',
    ];
    $body = '<customer>
        <username>SATA Travel</username>
        <password>7ef978320e84e67234eed6009363f7db</password>
        <id>1842675</id>
        <source>1</source>
        <product></product>
        <request command="getallcountries">
            <return>
                <fields>
                    <field>regionName</field>
                    <field>regionCode</field>
                </fields>
            </return>
        </request>
    </customer>';
    $request = new Request('POST', 'http://xmldev.dotwconnect.com/gatewayV4.dotw', $headers, $body);
    $res = $client->sendAsync($request)->wait();
    $xml = simplexml_load_string($res->getBody());
    $json = json_encode($xml);
    $countries = json_decode($json, true);
    $countries = $countries['countries']['country'];
    $notexits = [];
    foreach ($countries as $country) {
        $c = DB::table('wow_countries')->where('name_en', 'like', $country['name'])->first();
        if ($c) {
            DB::table('wow_supplier_country')->updateOrInsert(
                [
                    'supplier_id' => 2,
                    'country_id' => $c->id,
                ],
                [
                    'supplier_id' => 2,
                    'country_id' => $c->id,
                    'country_code' => $country['code'],
                    'region_code' => $country['regionCode'],
                ]
            );
        } else {
            $notexits[] = $country;
        }
    }
    return $notexits;
});

Route::get('/dotw_cities', function () {
    set_time_limit(0);
    $client = new Client();
    $headers = [
        'Connection' => 'close',
        'Compression' => 'Gzip',
        'Content-Type' => 'text/xml, application/x-www-form-urlencoded',
        'Content-Encoding' => 'gzip',
    ];
    $body = '<customer>
        <username>SATA Travel</username>
        <password>7ef978320e84e67234eed6009363f7db</password>
        <id>1842675</id>
        <source>1</source>
        <product></product>
        <request command="getallcities">
        <return>
            <fields>
                # <field>countryName</field>
                # <field>countryCode</field>
            </fields>
        </return>
    </request>
    </customer>';
    $request = new Request('POST', 'http://xmldev.dotwconnect.com/gatewayV4.dotw', $headers, $body);
    $res = $client->sendAsync($request)->wait();
    $xml = simplexml_load_string($res->getBody());
    $json = json_encode($xml);
    $cities = json_decode($json, true);
    return $cities;
    $cities = $cities['cities']['city'];
    foreach ($cities as $city) {
        $c = DB::table('wow_supplier_country')->where('country_code', $city['countryCode'])->first();
        if ($c) {
            $country_id = $c->country_id;
            DB::table('wow_cities')->updateOrInsert(
                [
                    'country_id' => $country_id,
                    'name_en' => $city['name'],
                ],
                [
                    'country_id' => $country_id,
                    'name_en' => $city['name'],
                ]
            );
            $city_id = Illuminate\Support\Facades\DB::getPdo()->lastInsertId();
            DB::table('wow_supplier_city')->updateOrInsert(
                [
                    'supplier_id' => 2,
                    'city_id' => $city_id,
                ],
                [
                    'supplier_id' => 2,
                    'city_id' => $city_id,
                    'city_code' => $city['code'],
                ]
            );
        }
    }
});

// ==============================================TBO ===============================
Route::get('/tbo_cities', function () {
    return DB::table('wow_supplier_city')->where('supplier_id', 1)->get();
    set_time_limit(0);
    $dotw_citites = DB::table('wow_cities')->get();
    $notexits = [];
    foreach ($dotw_citites as $city) {
        $tbo_city = DB::table('city_list')->where('city_name_en', 'like', $city->name_en)->first();
        if ($tbo_city) {
            $tbo_code = $tbo_city->city_tbo_code;
            $name_ar = $tbo_city->city_name_ar;
            //update arabic name from bkoffice city_list table
            DB::table('wow_cities')->where('id', $city->id)->update([
                'name_ar' => $name_ar,
            ]);
            //update tbo supplier code in supplier city table
            DB::table('wow_supplier_city')->updateOrInsert(
                [
                    'supplier_id' => 1,
                    'city_id' => $city->id,
                ],
                [
                    'supplier_id' => 1,
                    'city_id' => $city->id,
                    'city_code' => $tbo_code,
                ]
            );
        } else {
            DB::table('wow_cities')->where('id', $city->id)->update([
                'name_ar' => null,
            ]);
            $notexits[] = $city;
        }
    }
    return $notexits;
});
Route::get('/tbo_hotels', function () {
    $hotels = DB::table('hotel_list')->get();
    foreach ($hotels as $hotel) {
        $hotel_id = $hotel->hotel_id;
        $tbo_code = $hotel->hotel_tbo_code;
        //update tbo supplier code in supplier city table
        DB::table('wow_supplier_hotel')->updateOrInsert(
            [
                'supplier_id' => 15,
                'hotel_id' => $hotel_id,
            ],
            [
                'supplier_id' => 15,
                'hotel_id' => $hotel_id,
                'hotel_code' => $tbo_code,
            ]
        );
    }
});

// ============= beds =========================================
Route::get('/beds_countries', function () {

    $api = '654f3adebe111b5f0dab7dac224619c2';
    $sec = 'c4458411f6';
    $url="/hotel-content-api/1.0/locations/countries?fields=all&language=ENG&from=1&to=203";
    // $api='c356fd8a35a076de09e02a6f4a70dae8';
    // $sec='7ea00bc5c8';

    // $api='uxq7g6ru4b662qhnqs3xgv9e';
    // $sec='GZ4uwvpTRA';

    $sig = hash("sha256", $api . $sec . time());
    $client = new Client();
    $headers = [
        'Api-key' => $api,
        'X-Signature' => $sig,
        'Accept' => 'application/json',
        'Accept-Encoding' => 'gzip',
    ];
    $request = new Request('GET', 'https://api.test.hotelbeds.com' . $url, $headers);
    $res = $client->sendAsync($request)->wait();
    $res = $res->getBody()->getContents();
    // return $res;
    return $res;
    // foreach ($countries as $country) {
    //     $c = DB::table('wow_countries')->where('name_en', 'like', $country['name'])->first();
    //     if ($c) {
    //         DB::table('wow_supplier_country')->updateOrInsert(
    //             [
    //                 'supplier_id' => 3,
    //                 'country_id' => $c->id,
    //             ],
    //             [
    //                 'supplier_id' => 2,
    //                 'country_id' => $c->id,
    //                 'country_code' => $country['code'],
    //                 'region_code' => $country['regionCode']
    //             ]
    //         );
    //     } else {
    //         $notexits[] = $country;
    //     }
    // }
    // return $notexits;
});
 // cities
Route::get('/beds_cities',[BedsHotelsController::class,'getAllCities']);
Route::get('/ip',function(){
    $ip=ip2long('209.142.68.29');
   return DB::table('ip_address')->where('high_ip','=>',$ip)->where('low_ip','<=',$ip)->get();

});
Route::get('/map_beds_cities',[BedsHotelsController::class,'mapCities']);
Route::get('/store_reviewed_cities',[BedsHotelsController::class,'storeReviewedCities']);

//hotels
Route::get('/beds_hotels',[BedsHotelsController::class,'getAllHotels']);
Route::get('/map_beds_hotels',[BedsHotelsController::class,'mapHotels']);
Route::get('/store_reviewed_hotels',[BedsHotelsController::class,'storeReviewedHotels']);



