<?php

namespace Modules\Locales\Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\Locales\Entities\Country;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function countries_list()
    {
        $path = base_path() . '/Modules/Locales/Resources/country/countries.json';
        $countries = json_decode(file_get_contents($path), true);
        return $countries;
    }

    public function run()
    {
        $countries = $this->countries_list();
        foreach ((array)$countries as $country) {
            Country::updateOrCreate(['code' => $country['code']], $country);
        }
    }
}
