export default {
    //GET
    autocomplete_search(query) {
        return '/flights/auto_complete/' + query
    },
    search() {
        return '/flights/search'
    },
    select_flight() {
        return '/flights/select_flight'
    },
    pricing() {
        return '/flights/pricing'
    },
    book() {
        return '/flights/book'
    },
    pay_from_balance(id) {
        return '/flights/pay_from_balance/' + id
    },
    booking_details(merchant_ref) {
        return `/flights/booking_details/${merchant_ref}`
    },
    booking_list(page) {
        page = (page || 1)
        return `/flights/local_booking_list?page=${page}&page%5Bnumber%5D=${page}`
    },
    pre_payment(id) {
        return '/flights/pre_payment/' + id
    },
    cancel_booking(merchant_ref) {
        return `/flights/cancel_booking/${merchant_ref}`
    }
}