export default {
    
    list: {
        modules() {
            return `/admins/supplier_settings/modules`
        },
    },
    flights:{
        get(supplier){
            return `/admins/supplier_settings/flights/${supplier}`
        },
        post(supplier){
            return `/admins/supplier_settings/flights/${supplier}`
        },
        form(supplier){
            return `/admins/supplier_settings/flights/form/${supplier}`
        },
    },
    hotels:{
        get(supplier){
            return `/admins/supplier_settings/hotels/${supplier}`
        },
        post(supplier){
            return `/admins/supplier_settings/hotels/${supplier}`
        },
        form(supplier){
            return `/admins/supplier_settings/hotels/form/${supplier}`
        },
    },
    payments:{
        get(supplier){
            return `/admins/supplier_settings/payments/${supplier}`
        },
        post(supplier){
            return `/admins/supplier_settings/payments/${supplier}`
        },
        form(supplier){
            return `/admins/supplier_settings/payments/form/${supplier}`
        },
    },
    credentials: {
        list() {
            return '/admins/settings/credentials/show'
        },
        update() {
            return '/admins/settings/credentials/update'
        }
    },
    public: {
        list(id) {
            if(id){
                return `/admins/settings/public/show/${id}`
            }else{
                return `/admins/settings/public/show`
            }
        },
        update() {
            return '/admins/settings/public/update'
        }
    },
    app: {
        list() {
            return '/admins/settings/app/show'
        },
        update() {
            return '/admins/settings/app/update'
        }
    }
}
  