import dayjs from "dayjs";
export function daysBetween(from, to) {
    return Math.floor((new Date(from) - new Date(to)) / (1000*60*60*24))
}

export function secondsToDurations(seconds){
    const hours = Math.floor(seconds / 60 / 60);
    const minutes = Math.floor(seconds / 60) - (hours * 60);
    seconds = seconds % 60;
    return {
        hours: hours.toString(),
        minutes: minutes.toString(),
        seconds:seconds.toString()
    }
    // return `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}`
}

export function durationBetween(from, to) {
    return secondsToDurations(
        Math.floor((new Date(from) - new Date(to)) / 1000)
    )
}


export function duration(from, to){
    let d = (new Date(to)) - (new Date(from));
    let weekdays     = Math.floor(d/1000/60/60/24/7);
    let days         = Math.floor(d/1000/60/60/24 - weekdays*7);
    let hours        = Math.floor(d/1000/60/60    - weekdays*7*24            - days*24);
    let minutes      = Math.floor(d/1000/60       - weekdays*7*24*60         - days*24*60         - hours*60);
    let seconds      = Math.floor(d/1000          - weekdays*7*24*60*60      - days*24*60*60      - hours*60*60      - minutes*60);
    let milliseconds = Math.floor(d               - weekdays*7*24*60*60*1000 - days*24*60*60*1000 - hours*60*60*1000 - minutes*60*1000 - seconds*1000);
    let t = {};
    ['weekdays', 'days', 'hours', 'minutes', 'seconds', 'milliseconds'].forEach((q)=>{
        if (eval(q)>0) {
            t[q] = eval(q); 
        } 
    });
    return t;
}

export function addDays(date, days){
    const currentDate = new Date(date);
    return currentDate.setDate(currentDate.getDate() + days );
}

export function useFormate({options, lang}) {
    if(!options){
        options = {  weekday: 'long', month: 'long', day: 'numeric', year: 'numeric'};
    }
    return (date) => {
        let locale = lang.fullLocale.value == 'ar-SA' ? 'ar-EG' : lang.fullLocale.value
        return new Intl.DateTimeFormat(locale, options).format(new Date(date));
    }
}

export function shorthandToDate(date, time){
    const year = (new Date()).getFullYear().toString().substr(0, 2) 
    return new Date(year +date.substr(-2), date.substr(2,2), date.substr(0,2), time.substr(0,2), time.substr(2,2))
}

export function dateToShorthand(date){
    return dayjs(date).format('DD-MM-YY HH:mm:ss')
    date= new Date(date)
    let short = {
        year: date.getFullYear().toString().substr(-2).padStart(2, '0'),
        month: (date.getMonth() + 1).toString().padStart(2, '0'),
        day: date.getDay().toString().padStart(2, '0')
    } 

    return new Date(year +date.substr(-2), date.substr(2,2), date.substr(0,2), time.substr(0,2), time.substr(2,2))
}
